/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class CompTestCommand
extends PixelCommand {
    public CompTestCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "comptest", "/comptest [player] <box> <slot> <specs...>", 2);
    }

    @Override
    public boolean executeCommand(CommandSourceStack sender, String[] args) throws CommandRuntimeException, CommandSyntaxException {
        if ((args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 0)).length < 3) {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        ServerPlayer target = PixelmonCommandUtils.requireEntityPlayer(args[0]);
        PCStorage storage = PixelmonCommandUtils.require(StorageProxy.getPCForPlayerNow(target), "pixelmon.command.general.invalidplayer", new Object[0]);
        int box = PixelmonCommandUtils.requireInt(args[1], 1, storage.getBoxCount(), "pixelmon.command.box", storage.getBoxCount());
        int slot = PixelmonCommandUtils.requireInt(args[2], 1, 30, "pixelmon.command.slot", 30);
        StoragePosition storagePosition = new StoragePosition(box - 1, slot - 1);
        Pokemon pokemon = PixelmonCommandUtils.require(storage.get(storagePosition), "pixelmon.command.compslot.nothing", target.m_7755_());
        CharSequence[] specList = Arrays.copyOfRange(args, 2, args.length);
        ParseAttempt<PokemonSpecification> parseAttempt = PokemonSpecificationProxy.create(String.join((CharSequence)" ", specList));
        if (!parseAttempt.wasSuccess()) {
            sender.m_81352_((Component)PixelmonCommandUtils.format(ChatFormatting.GREEN, "pixelmon.command.spec.invalid", parseAttempt.getError()));
            return false;
        }
        PokemonSpecification spec = parseAttempt.get();
        if (spec.matches(pokemon)) {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.GREEN, "pixelmon.command.comptest.match", pokemon.getLocalizedName()), false);
            return true;
        }
        sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.comptest.nomatch", pokemon.getLocalizedName()), false);
        return false;
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        boolean hasPermissionOtherTarget = this.hasPermissionOtherTarget(sender);
        switch (args.length) {
            case 0: {
                return super.getTabCompletions(server, sender, args, pos);
            }
            case 1: {
                if (hasPermissionOtherTarget) {
                    return PixelmonCommandUtils.tabCompleteUsernames();
                }
                return IntStream.range(1, 100).mapToObj(String::valueOf).toList();
            }
            case 2: {
                if (hasPermissionOtherTarget) {
                    return IntStream.range(1, 100).mapToObj(String::valueOf).toList();
                }
                return IntStream.range(1, 30).mapToObj(String::valueOf).toList();
            }
            case 3: {
                if (!hasPermissionOtherTarget) break;
                return IntStream.range(1, 30).mapToObj(String::valueOf).toList();
            }
        }
        return PixelmonCommandUtils.SPEC_REQUIREMENTS;
    }
}

