/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class CompTakeCommand
extends PixelCommand {
    private static final List<String> ALIASES = Lists.newArrayList((Object[])new String[]{"pctake", "ctake"});

    public CompTakeCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "comptake", "/comptake <player> <box> <slot>", 2);
    }

    @Override
    public List<String> getAliases() {
        return ALIASES;
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException {
        if (args.length < 3) {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        ServerPlayer target = PixelmonCommandUtils.requireEntityPlayer(args[0]);
        PCStorage storage = PixelmonCommandUtils.require(PixelmonCommandUtils.getComputerStorage(target), "pixelmon.command.general.invalidplayer", new Object[0]);
        int box = PixelmonCommandUtils.requireInt(args[1], 1, storage.getBoxCount(), "pixelmon.command.box", storage.getBoxCount());
        int slot = PixelmonCommandUtils.requireInt(args[2], 1, 30, "pixelmon.command.slot", 30);
        StoragePosition storagePosition = new StoragePosition(box - 1, slot - 1);
        Pokemon pokemon = PixelmonCommandUtils.require(storage.get(storagePosition), "pixelmon.command.compslot.nothing", target.m_7755_());
        storage.set(pokemon.getPosition(), null);
        ServerPlayer senderPlayer = (ServerPlayer)sender.m_81373_();
        PixelmonCommandUtils.getComputerStorage(senderPlayer).add(pokemon);
        sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.GREEN, "pixelmon.command.comptake.success", pokemon.getLocalizedName(), args[0]), false);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1) {
            return PixelmonCommandUtils.tabCompleteUsernames();
        }
        if (args.length == 2) {
            return IntStream.range(1, 100).mapToObj(String::valueOf).toList();
        }
        if (args.length == 3) {
            return IntStream.range(1, 30).mapToObj(String::valueOf).toList();
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

