/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PCBox;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.util.helpers.CommandHelper;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class CompSeeCommand
extends PixelCommand {
    private static final List<String> ALIASES = Lists.newArrayList((Object[])new String[]{"pokecompsee", "pcompsee"});

    public CompSeeCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "compsee", "/compsee [player] <box>", 2);
    }

    @Override
    public List<String> getAliases() {
        return ALIASES;
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException, CommandSyntaxException {
        int box;
        ServerPlayer player;
        PCStorage storage;
        List<Component> pokemonList;
        if ((args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 0)).length < 2) {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        if ((pokemonList = this.searchComputerPokemon((storage = PixelmonCommandUtils.require(PixelmonCommandUtils.getComputerStorage(player = PixelmonCommandUtils.requireEntityPlayer(args[0])), "pixelmon.command.general.invalidplayer", new Object[0])).getBox((box = PixelmonCommandUtils.requireInt(args.length >= 3 ? args[2] : args[1], 1, storage.getBoxCount(), "pixelmon.command.compsee.notspecified", new Object[0])) - 1))).isEmpty()) {
            PixelmonCommandUtils.endCommand("pixelmon.command.compsee.noresults", new Object[0]);
        }
        sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.AQUA, "pixelmon.command.compsee.header", player.m_7755_().getString(), "" + box), false);
        for (Component c : pokemonList) {
            sender.m_288197_(() -> c, false);
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1 && this.hasPermissionOtherTarget(sender)) {
            return PixelmonCommandUtils.tabCompleteUsernames();
        }
        return IntStream.range(1, 100).mapToObj(String::valueOf).toList();
    }

    private List<Component> searchComputerPokemon(PCBox box) {
        int boxLimit = 30;
        ArrayList pokemonList = Lists.newArrayList();
        for (int slot = 0; slot < boxLimit; ++slot) {
            Pokemon pokemon = box.get(slot);
            if (pokemon == null) continue;
            pokemonList.add(CommandHelper.getHoverTextPokemon(pokemon, box.boxNumber, slot + 1));
        }
        return pokemonList;
    }
}

