/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PCBox;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.util.helpers.CommandHelper;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class CompSearchCommand
extends PixelCommand {
    private static final List<String> ALIASES = Lists.newArrayList((Object[])new String[]{"pokecompsearch", "pcompsearch"});

    public CompSearchCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "compsearch", "/compsearch [player] <specs...>", 2);
    }

    @Override
    public List<String> getAliases() {
        return ALIASES;
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException, CommandSyntaxException {
        if ((args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 0)).length < 2) {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        ServerPlayer player = PixelmonCommandUtils.requireEntityPlayer(args[0]);
        PCStorage storage = PixelmonCommandUtils.require(PixelmonCommandUtils.getComputerStorage(player), "pixelmon.command.general.invalidplayer", new Object[0]);
        String[] spec = new String[args.length - 1];
        ArrayList speclist = Lists.newArrayList((Object[])args);
        speclist.remove(0);
        for (int i = 0; i < speclist.size(); ++i) {
            spec[i] = (String)speclist.get(i);
        }
        List<Component> pokemonList = this.searchComputerPokemon(spec, storage);
        if (pokemonList.isEmpty()) {
            PixelmonCommandUtils.endCommand("pixelmon.command.compsearch.noresults", new Object[0]);
        }
        sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.AQUA, "pixelmon.command.compsearch.header", player.m_7755_().getString()), false);
        for (Component c : pokemonList) {
            sender.m_288197_(() -> c, false);
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1 && this.hasPermissionOtherTarget(sender)) {
            return PixelmonCommandUtils.tabCompleteUsernames();
        }
        return PixelmonCommandUtils.SPEC_REQUIREMENTS;
    }

    private List<Component> searchComputerPokemon(String[] args, PCStorage storage) {
        PCBox[] storageBoxes = storage.getBoxes();
        int boxCount = storage.getBoxCount();
        int boxLimit = 30;
        ArrayList<Component> pokemonList = new ArrayList<Component>();
        PokemonSpecification spec = PokemonSpecificationProxy.create(args).get();
        for (int i = 0; i < boxCount; ++i) {
            ArrayList<MutableComponent> boxList = new ArrayList<MutableComponent>();
            PCBox b = storageBoxes[i];
            for (int j = 0; j < boxLimit; ++j) {
                Pokemon pokemon = b.get(j);
                if (pokemon == null || !spec.matches(pokemon)) continue;
                boxList.add(CommandHelper.getHoverTextPokemon(pokemon, i + 1, j + 1));
            }
            if (boxList.size() == 0) continue;
            pokemonList.addAll(boxList);
        }
        return pokemonList;
    }
}

