/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.log.BattleLog;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.List;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.server.ServerLifecycleHooks;

public class BattleLogCommand
extends PixelCommand {
    public BattleLogCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "battlelog", "/battlelog [player]", 2);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException {
        if (args.length < 1) {
            if (!(sender.m_81373_() instanceof ServerPlayer)) {
                PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.battlelog.not.player", new Object[0]);
                return;
            }
            BattleController battle = BattleRegistry.getBattle((Player)sender.m_81373_());
            if (battle == null) {
                PlayerPartyStorage party = StorageProxy.getPartyNow((ServerPlayer)sender.m_81373_());
                if (party.getLastBattle() == null) {
                    PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.battlelog.not.battling", new Object[0]);
                    return;
                }
                this.sendLog(sender, party.getLastBattle());
                return;
            }
            this.sendLog(sender, battle.battleLog);
            return;
        }
        ServerPlayer target = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11255_(args[0]);
        if (target == null) {
            PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.battlelog.player.not.found", new Object[0]);
            return;
        }
        BattleController battle = BattleRegistry.getBattle((Player)target);
        if (battle == null) {
            PlayerPartyStorage party = StorageProxy.getPartyNow(target);
            if (party.getLastBattle() == null) {
                PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.battlelog.not.battling", new Object[0]);
                return;
            }
            this.sendLog(sender, party.getLastBattle());
            return;
        }
        this.sendLog(sender, battle.battleLog);
    }

    private void sendLog(CommandSourceStack sender, BattleLog log) {
        try {
            log.exportLogFile(null, null).whenComplete((file, throwable) -> PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.battlelog.logged", iFormattableTextComponent -> iFormattableTextComponent.m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getAbsolutePath()))), new Object[0]));
        }
        catch (Exception e) {
            PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.battlelog.failed", new Object[0]);
            e.printStackTrace();
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        return PixelmonCommandUtils.tabCompleteUsernames();
    }
}

