/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.aggression.Aggression;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.CollectionHelper;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.TrainerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.command.impl.Battle2;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BattleCommand
extends PixelCommand {
    public BattleCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher, "pokebattle", "/pokebattle <participant1> <participant2> [<participant3> <participant4>]", 2);
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException, CommandSyntaxException {
        if (args.length == 2 || args.length == 3 || args.length == 4) {
            Player source;
            int i;
            BattleRules br = new BattleRules();
            br.set(BattleRuleRegistry.BATTLE_TYPE, (Object)(args.length == 2 ? BattleType.SINGLE : BattleType.DOUBLE));
            Object[] entities = new Entity[args.length];
            for (i = 0; i < entities.length; ++i) {
                entities[i] = PixelmonCommandUtils.require(this.getParticipant(sender, args[i]), "pixelmon.command.battle2.invalid", i + 1);
            }
            if (CollectionHelper.find(Lists.newArrayList((Object[])entities), e -> e instanceof NPCTrainer) != null) {
                NPCTrainer trainer = (NPCTrainer)CollectionHelper.find(Lists.newArrayList((Object[])entities), e -> e instanceof NPCTrainer);
                if (!trainer.battleRules.isDefault()) {
                    br.importText(trainer.battleRules.exportText());
                }
            }
            for (i = 0; i < entities.length; ++i) {
                Object e2 = entities[i];
                for (int j = 0; j < entities.length; ++j) {
                    if (i == j || ((Entity)e2).f_19853_ == ((Entity)entities[j]).f_19853_) continue;
                    PixelmonCommandUtils.endCommand("pixelmon.command.battle.dimension", new Object[0]);
                }
                int requiredPokemon = 1;
                if (e2 instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e2;
                    for (int j = 0; j < entities.length; ++j) {
                        if (i == j || e2 != entities[j]) continue;
                        if (br.getOrDefault(BattleRuleRegistry.BATTLE_TYPE) == BattleType.SINGLE) {
                            PixelmonCommandUtils.endCommand("pixelmon.command.battle2.duplicate", new Object[0]);
                            continue;
                        }
                        if (br.getOrDefault(BattleRuleRegistry.BATTLE_TYPE) != BattleType.DOUBLE) continue;
                        ++requiredPokemon;
                        if ((i >= 2 || j < 2) && (j >= 2 || i < 2)) continue;
                        PixelmonCommandUtils.endCommand("pixelmon.command.battle2.differing", new Object[0]);
                    }
                    if (BattleRegistry.getBattle((Player)e2) != null) {
                        PixelmonCommandUtils.endCommand("pixelmon.command.battle.cannotchallenge", player.m_7755_());
                    }
                    PlayerPartyStorage j = StorageProxy.getPartyNow(player);
                    continue;
                }
                if (!(e2 instanceof NPCTrainer)) continue;
                NPCTrainer trainer = (NPCTrainer)((Object)e2);
                if (trainer.battleController == null) continue;
                PixelmonCommandUtils.endCommand("pixelmon.command.battle.cannotchallenge", trainer.m_7755_());
            }
            Object object = source = sender.m_81373_() instanceof Player ? (Player)sender.m_81373_() : Arrays.stream(entities).filter(entity -> entity instanceof ServerPlayer || entity instanceof NPCEntity).findFirst().get();
            if (br.getOrDefault(BattleRuleRegistry.BATTLE_TYPE) == BattleType.SINGLE) {
                BattleParticipant one = this.prepareParticipant((Entity)entities[0], br.getOrDefault(BattleRuleRegistry.BATTLE_TYPE).getNumPokemon(), (Entity)source);
                BattleParticipant two = this.prepareParticipant((Entity)entities[1], br.getOrDefault(BattleRuleRegistry.BATTLE_TYPE).getNumPokemon(), (Entity)source);
                BattleRegistry.startBattle(new BattleParticipant[]{one}, new BattleParticipant[]{two}, br);
                PixelmonCommandUtils.notifyCommandListener(sender, this, 0, "pixelmon.command.battle.started", one.getDisplayName(), two.getDisplayName());
            } else if (br.getOrDefault(BattleRuleRegistry.BATTLE_TYPE) == BattleType.DOUBLE) {
                BattleParticipant[] battleParticipantArray;
                BattleParticipant[] battleParticipantArray2;
                Object four;
                Object three;
                Object two;
                Object one;
                BattleParticipant[][] teams = new BattleParticipant[2][];
                if (entities.length == 2) {
                    one = entities[0];
                    two = entities[0];
                    three = entities[1];
                    four = entities[1];
                } else if (entities.length == 3) {
                    one = entities[0];
                    two = entities[0];
                    three = entities[1];
                    four = entities[2];
                } else {
                    one = entities[0];
                    two = entities[1];
                    three = entities[2];
                    four = entities[3];
                }
                if (one == two) {
                    BattleParticipant[] battleParticipantArray3 = new BattleParticipant[1];
                    battleParticipantArray2 = battleParticipantArray3;
                    battleParticipantArray3[0] = this.prepareParticipant((Entity)one, 2, (Entity)source);
                } else {
                    BattleParticipant[] battleParticipantArray4 = new BattleParticipant[2];
                    battleParticipantArray4[0] = this.prepareParticipant((Entity)one, 1, (Entity)source);
                    battleParticipantArray2 = battleParticipantArray4;
                    battleParticipantArray4[1] = this.prepareParticipant((Entity)two, 1, (Entity)source);
                }
                teams[0] = battleParticipantArray2;
                if (three == four) {
                    BattleParticipant[] battleParticipantArray5 = new BattleParticipant[1];
                    battleParticipantArray = battleParticipantArray5;
                    battleParticipantArray5[0] = this.prepareParticipant((Entity)three, 2, (Entity)source);
                } else {
                    BattleParticipant[] battleParticipantArray6 = new BattleParticipant[2];
                    battleParticipantArray6[0] = this.prepareParticipant((Entity)three, 1, (Entity)source);
                    battleParticipantArray = battleParticipantArray6;
                    battleParticipantArray6[1] = this.prepareParticipant((Entity)four, 1, (Entity)source);
                }
                teams[1] = battleParticipantArray;
                BattleRegistry.startBattle(teams[0], teams[1], br);
                PixelmonCommandUtils.notifyCommandListener(sender, this, 0, "pixelmon.command.battle.started", Arrays.toString(Arrays.stream(teams[0]).map(BattleParticipant::getDisplayName).toArray()), Arrays.toString(Arrays.stream(teams[1]).map(BattleParticipant::getDisplayName).toArray()));
            }
        } else {
            sender.m_288197_(() -> PixelmonCommandUtils.format(ChatFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
    }

    private BattleParticipant prepareParticipant(Entity e, int numPokemon, Entity source) {
        if (e instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)e;
            PlayerPartyStorage party = StorageProxy.getPartyNow(player);
            List<Pokemon> pokemon = party.findAll(Pokemon::canBattle);
            PixelmonEntity[] pixelmons = new PixelmonEntity[numPokemon];
            for (int i = 0; i < pixelmons.length; ++i) {
                pixelmons[i] = pokemon.get(i).getOrSpawnPixelmon((Entity)player);
            }
            return new PlayerParticipant(player, pixelmons);
        }
        if (e instanceof NPCTrainer) {
            NPCTrainer trainer = (NPCTrainer)e;
            return new TrainerParticipant(trainer, numPokemon);
        }
        if (e instanceof PixelmonEntity) {
            PixelmonEntity pixelmon = (PixelmonEntity)e;
            pixelmon.aggression = Aggression.PASSIVE;
            pixelmon.m_6034_(source.m_20185_() + 2.0, Battle2.getTopEarthBlock(source.f_19853_, (int)source.m_20185_(), (int)source.m_20189_()), source.m_20189_());
            pixelmon.f_19853_.m_7967_((Entity)pixelmon);
            return new WildPixelmonParticipant(pixelmon);
        }
        return null;
    }

    private Entity getParticipant(CommandSourceStack sender, String value) throws CommandSyntaxException {
        ServerPlayer playerMP = PixelmonCommandUtils.getEntityPlayer(value);
        if (playerMP != null) {
            return playerMP;
        }
        List players = PixelmonCommandUtils.getEntitySelector(value).m_121166_(sender);
        if (players.size() == 1) {
            return (Entity)players.get(0);
        }
        ParseAttempt<PokemonSpecification> parseAttempt = PokemonSpecificationProxy.create(value);
        if (!parseAttempt.wasSuccess()) {
            return null;
        }
        PokemonSpecification spec = parseAttempt.get();
        RegistryValue species = spec.getValue(SpeciesRequirement.class).orElse(null);
        if (species != null && species.isInitialized()) {
            Vec3 pos = sender.m_81371_();
            PixelmonEntity pixelmon = spec.create((Level)sender.m_81372_());
            pixelmon.m_6034_(pos.m_7096_() + 0.5, pos.m_7098_(), pos.m_7094_() + 0.5);
            return pixelmon;
        }
        String langCode = sender.m_81373_() instanceof ServerPlayer ? ((ServerPlayer)sender.m_81373_()).getLanguage() : "en_US";
        Optional<NPCTrainer> trainer = NPCEntity.locateNPCServer((Level)sender.m_81372_(), value, NPCTrainer.class, langCode);
        return trainer.orElse(null);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) {
        if (args.length <= 4) {
            List<String> list = PixelmonCommandUtils.tabCompleteUsernames();
            if (list.isEmpty()) {
                list = PixelmonCommandUtils.tabCompletePokemon();
            }
            return list;
        }
        return Collections.emptyList();
    }
}

