/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.aggression.Aggression;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.RegexPatterns;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.TrainerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.comm.CommandChatHandler;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;

public class Battle2
extends PixelCommand {
    public Battle2(CommandDispatcher<CommandSourceStack> dispatcher) {
        super(dispatcher);
    }

    @Override
    public String getName() {
        return "pokebattle2";
    }

    @Override
    public String getUsage(CommandSourceStack sender) {
        return "/pokebattle2 <player> <player|pokemon> <player|pokemon> <player|pokemon>";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException {
        if (args.length < 2) {
            PixelmonCommandUtils.sendMessage(sender, this.getUsage(sender), new Object[0]);
            return;
        }
        try {
            BattleParticipant[] team2;
            BattleParticipant[] team1;
            ArrayList<BattleParticipant> participants = new ArrayList<BattleParticipant>();
            ArrayList<PixelmonEntity> wildPixelmon = new ArrayList<PixelmonEntity>();
            ArrayList<String> playerNames = new ArrayList<String>();
            int numParticipants = 0;
            for (String arg : args) {
                if (arg.startsWith("lvl")) continue;
                ++numParticipants;
            }
            if (numParticipants < 2 || numParticipants > 4) {
                PixelmonCommandUtils.sendMessage(sender, ChatFormatting.RED, "pixelmon.command.battle2.cantstart", new Object[0]);
            }
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("lvl")) continue;
                Object part = this.getPart(sender, args[i]);
                if (part == null) {
                    PixelmonCommandUtils.sendMessage(sender, ChatFormatting.RED, "pixelmon.command.battle2.invalid", i + 1);
                    return;
                }
                if (part instanceof ServerPlayer) {
                    ServerPlayer playerPart = (ServerPlayer)part;
                    if (BattleRegistry.getBattle((Player)playerPart) != null) {
                        PixelmonCommandUtils.sendMessage(sender, ChatFormatting.RED, "sendpixelmon.inbattle", playerPart.m_5446_());
                        return;
                    }
                    if (playerNames.contains(playerPart.m_5446_().getString())) {
                        PixelmonCommandUtils.sendMessage(sender, ChatFormatting.RED, "pixelmon.command.battle2.duplicate", new Object[0]);
                        return;
                    }
                    playerNames.add(playerPart.m_5446_().getString());
                    PlayerPartyStorage party = StorageProxy.getPartyNow(playerPart);
                    List<Pokemon> availablePokemon = party.findAll(Pokemon::canBattle);
                    PixelmonEntity[] leadPokemon = numParticipants == 2 || numParticipants == 3 && i == 0 ? (availablePokemon.isEmpty() ? new PixelmonEntity[]{null, null} : (availablePokemon.size() == 1 ? new PixelmonEntity[]{availablePokemon.get(0).getOrSpawnPixelmon((Entity)playerPart)} : new PixelmonEntity[]{availablePokemon.get(0).getOrSpawnPixelmon((Entity)playerPart), availablePokemon.get(1).getOrSpawnPixelmon((Entity)playerPart)})) : new PixelmonEntity[]{party.getAndSendOutFirstAblePokemon((Entity)playerPart)};
                    if (leadPokemon.length > 0 && leadPokemon[0] != null) {
                        participants.add(new PlayerParticipant(playerPart, leadPokemon));
                        continue;
                    }
                    PixelmonCommandUtils.sendMessage(sender, ChatFormatting.RED, "pixelmon.command.battle.nopokemon", playerPart.m_5446_());
                    return;
                }
                if (part instanceof PixelmonEntity) {
                    PixelmonEntity wildPart = (PixelmonEntity)((Object)part);
                    if (i == 0) {
                        PixelmonCommandUtils.sendMessage(sender, ChatFormatting.RED, "pixelmon.command.battle2.first", new Object[0]);
                        return;
                    }
                    if (i + 1 < args.length && args[i + 1].startsWith("lvl")) {
                        int level = Integer.parseInt(RegexPatterns.LETTERS.matcher(args[i + 1]).replaceAll(""));
                        if (level > 0 && level <= PixelmonServerConfig.maxLevel) {
                            wildPart.getLvl().setLevel(level);
                        } else {
                            PixelmonCommandUtils.sendMessage(sender, ChatFormatting.RED, "pixelmon.command.general.cheater", new Object[0]);
                        }
                    } else {
                        wildPart.getLvl().setLevel(((PlayerParticipant)participants.get(0)).getHighestLevel());
                    }
                    wildPixelmon.add(wildPart);
                    participants.add(new WildPixelmonParticipant(wildPart));
                    continue;
                }
                if (!(part instanceof NPCTrainer)) continue;
                NPCTrainer trainer = (NPCTrainer)((Object)part);
                if (trainer.battleController != null) {
                    PixelmonCommandUtils.sendMessage(sender, ChatFormatting.RED, "sendpixelmon.inbattle", trainer.m_7755_());
                    return;
                }
                participants.add(new TrainerParticipant(trainer, 2));
            }
            ServerPlayer player = ((PlayerParticipant)participants.get((int)0)).player;
            for (int i = 0; i < wildPixelmon.size(); ++i) {
                PixelmonEntity p = (PixelmonEntity)((Object)wildPixelmon.get(i));
                p.aggression = Aggression.PASSIVE;
                if (i == 0) {
                    p.m_6034_(player.m_20185_() + 2.0, Battle2.getTopEarthBlock(player.f_19853_, (int)player.m_20185_(), (int)player.m_20189_()), player.m_20189_());
                } else if (i == 1) {
                    p.m_6034_(player.m_20185_(), Battle2.getTopEarthBlock(player.f_19853_, (int)player.m_20185_(), (int)player.m_20189_()), player.m_20189_() + 2.0);
                } else if (i == 2) {
                    p.m_6034_(player.m_20185_() + 2.0, Battle2.getTopEarthBlock(player.f_19853_, (int)player.m_20185_(), (int)player.m_20189_()), player.m_20189_() + 2.0);
                }
                player.f_19853_.m_7967_((Entity)p);
            }
            ArrayList battleParticipants = new ArrayList();
            if (numParticipants == 2) {
                team1 = new BattleParticipant[]{(BattleParticipant)participants.get(0)};
                team2 = new BattleParticipant[]{(BattleParticipant)participants.get(1)};
            } else if (numParticipants == 3) {
                team1 = new BattleParticipant[]{(BattleParticipant)participants.get(0)};
                team2 = new BattleParticipant[]{(BattleParticipant)participants.get(1), (BattleParticipant)participants.get(2)};
                for (BattleParticipant participant : team2) {
                    if (!(participant instanceof TrainerParticipant)) continue;
                    participant.setNumControlledPokemon(1);
                }
            } else if (numParticipants == 4) {
                team1 = new BattleParticipant[]{(BattleParticipant)participants.get(0), (BattleParticipant)participants.get(1)};
                team2 = new BattleParticipant[]{(BattleParticipant)participants.get(2), (BattleParticipant)participants.get(3)};
                for (BattleParticipant participant : participants) {
                    if (!(participant instanceof TrainerParticipant)) continue;
                    participant.setNumControlledPokemon(1);
                }
            } else {
                CommandChatHandler.sendChat(sender, "pixelmon.command.battle2.cantstart", new Object[0]);
                return;
            }
            ((BattleParticipant)participants.get((int)0)).startedBattle = true;
            BattleRegistry.startBattle(team1, team2, new BattleRules(BattleType.DOUBLE));
        }
        catch (NumberFormatException e) {
            PixelmonCommandUtils.sendMessage(sender, ChatFormatting.RED, "pixelmon.command.battle2.pokemonLevel", new Object[0]);
        }
        catch (ClassCastException e) {
            PixelmonCommandUtils.sendMessage(sender, ChatFormatting.RED, "pixelmon.command.battle2.cantstart", new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getTopEarthBlock(Level world, int cpX, int cpZ) {
        LevelChunk chunk = world.m_46745_(new BlockPos(cpX, 0, cpZ));
        Integer k = null;
        k = Math.max(0, Math.min(chunk.m_62098_() + 15, 255));
        while (k > 0) {
            BlockState blockState = world.m_8055_(new BlockPos(cpX, k.intValue(), cpZ));
            if (blockState.m_60734_() != Blocks.f_50016_ && !blockState.m_60734_().m_48673_(blockState)) {
                return k + 1;
            }
            k = k - 1;
        }
        return chunk.m_62098_() + 15;
    }

    private Object getPart(CommandSourceStack sender, String value) {
        ServerPlayer player = PixelmonCommandUtils.getEntityPlayer(value);
        if (player != null) {
            return player;
        }
        ParseAttempt<PokemonSpecification> parseAttempt = PokemonSpecificationProxy.create(value);
        if (!parseAttempt.wasSuccess()) {
            return null;
        }
        PokemonSpecification spec = parseAttempt.get();
        RegistryValue species = spec.getValue(SpeciesRequirement.class).orElse(null);
        if (species == null || !species.isInitialized()) {
            String langCode = sender.m_81373_() instanceof ServerPlayer ? ((ServerPlayer)sender.m_81373_()).getLanguage() : "en_US";
            Optional<NPCTrainer> trainer = NPCEntity.locateNPCServer((Level)sender.m_81372_(), value, NPCTrainer.class, langCode);
            return trainer.orElse(null);
        }
        return spec.create((Level)sender.m_81372_());
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) {
        if (args.length >= 1 && args.length <= 4) {
            return PixelmonCommandUtils.tabCompleteUsernames();
        }
        return Collections.emptyList();
    }
}

