/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.util.helpers.ArrayHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.BrigadierHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.server.ServerLifecycleHooks;

public abstract class PixelCommand {
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s");
    private final String name;
    private final String usage;
    private final int permissionLevel;

    public PixelCommand(CommandDispatcher<CommandSourceStack> dispatcher, String name, String usage, int permissionLevel) {
        this.name = name;
        this.usage = usage;
        this.permissionLevel = permissionLevel;
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)this.getName()).requires(commandSource -> commandSource.m_6761_(this.permissionLevel))).then(Commands.m_82129_((String)"", (ArgumentType)StringArgumentType.greedyString()).suggests(this::buildSuggestions).executes(context -> this.handleExecution((CommandContext<CommandSourceStack>)context, ((String)context.getArgument("", String.class)).split(" "))))).executes(context -> this.handleExecution((CommandContext<CommandSourceStack>)context, new String[0]));
        LiteralCommandNode args = dispatcher.register(builder);
        for (String alias : this.getAliases()) {
            dispatcher.getRoot().addChild(BrigadierHelper.buildRedirect(alias, (LiteralCommandNode<CommandSourceStack>)args));
        }
    }

    public PixelCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        this(dispatcher, "", "", 0);
    }

    private CompletableFuture<Suggestions> buildSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        List<String> tabCompletions;
        String[] initialArgs = context.getInput().split(" ");
        ArrayList args = Lists.newArrayList((Object[])Arrays.copyOfRange(initialArgs, 1, initialArgs.length));
        int spaces = 0;
        Matcher matcher = SPACE_PATTERN.matcher(context.getInput());
        while (matcher.find()) {
            ++spaces;
        }
        while (spaces > args.size()) {
            args.add(" ");
            --spaces;
        }
        try {
            tabCompletions = this.getTabCompletions(ServerLifecycleHooks.getCurrentServer(), (CommandSourceStack)context.getSource(), args.toArray(new String[0]), new BlockPos((int)((CommandSourceStack)context.getSource()).m_81371_().m_7096_(), (int)((CommandSourceStack)context.getSource()).m_81371_().m_7098_(), (int)((CommandSourceStack)context.getSource()).m_81371_().m_7094_()));
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            return builder.buildFuture();
        }
        return CompletableFuture.supplyAsync(() -> {
            SuggestionsBuilder suggestionsBuilder = null;
            suggestionsBuilder = args.size() > 0 && !((String)args.get(args.size() - 1)).trim().isEmpty() ? builder.createOffset(context.getInput().length() - ((String)args.get(args.size() - 1)).length()) : builder.createOffset(context.getInput().length());
            String currentWord = ((String)args.get(args.size() - 1)).toLowerCase(Locale.ROOT);
            for (String tabCompletion : tabCompletions) {
                if (args.isEmpty()) {
                    suggestionsBuilder.suggest(tabCompletion);
                    continue;
                }
                if (currentWord.isEmpty() || currentWord.equals(" ")) {
                    suggestionsBuilder.suggest(tabCompletion);
                    continue;
                }
                if (!tabCompletion.regionMatches(true, 0, currentWord, 0, currentWord.length())) continue;
                suggestionsBuilder.suggest(tabCompletion);
            }
            return suggestionsBuilder;
        }).thenCompose(SuggestionsBuilder::buildFuture);
    }

    private int handleExecution(CommandContext<CommandSourceStack> context, String[] args) {
        try {
            return this.executeCommand((CommandSourceStack)context.getSource(), args) ? 1 : 0;
        }
        catch (CommandSyntaxException e) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)e.getContext()), false);
            return 0;
        }
        catch (CommandRuntimeException e) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> ((CommandRuntimeException)e).m_79226_(), false);
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getUsage(CommandSourceStack sender) {
        if (this.hasPermissionOtherTarget(sender)) {
            return this.usage;
        }
        return this.usage.replace("[player] ", "");
    }

    public int getRequiredPermissionLevel() {
        return this.permissionLevel;
    }

    public List<String> getAliases() {
        return Collections.emptyList();
    }

    public boolean executeCommand(CommandSourceStack sender, String[] args) throws CommandRuntimeException, CommandSyntaxException {
        this.execute(sender, args);
        return true;
    }

    public void execute(CommandSourceStack sender, String[] args) throws CommandRuntimeException, CommandSyntaxException {
    }

    public List<String> getTabCompletions(MinecraftServer server, CommandSourceStack sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        return Collections.emptyList();
    }

    public String[] setupTargetOrSourceAsTarget(CommandSourceStack sender, String[] args, int playerIndex) throws CommandSyntaxException, CommandRuntimeException {
        if (args.length > playerIndex) {
            boolean isTargetOther;
            boolean isTargetMissingInArguments;
            String selector = args[playerIndex];
            ServerPlayer target = PixelmonCommandUtils.getEntityPlayer(selector);
            boolean bl = isTargetMissingInArguments = target == null;
            if (isTargetMissingInArguments) {
                boolean isTargetOffline;
                GameProfile profile = PixelmonCommandUtils.findProfile(selector);
                boolean bl2 = isTargetOffline = profile != null && !profile.getName().equalsIgnoreCase(sender.m_81368_());
                if (isTargetOffline) {
                    throw PixelmonCommandUtils.getException("pixelmon.command.other.offline", profile.getName());
                }
                return this.addSourceToArgumentsAndGet(sender, args, playerIndex);
            }
            boolean bl3 = isTargetOther = target != sender.m_81373_();
            if (isTargetOther && !this.hasPermissionOtherTarget(sender)) {
                throw PixelmonCommandUtils.getException("pixelmon.command.other.nopermission", new Object[0]);
            }
            return args;
        }
        return this.addSourceToArgumentsAndGet(sender, args, playerIndex);
    }

    private String[] addSourceToArgumentsAndGet(CommandSourceStack sender, String[] args, int playerIndex) {
        return ArrayHelper.addStringAtIndex(args, playerIndex, sender.m_81368_());
    }

    public boolean hasPermissionOtherTarget(CommandSourceStack sender) {
        return PixelmonCommandUtils.hasPermission(sender, "pixelmon.command." + this.name + ".other");
    }
}

