/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.zygarde;

import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.blocks.tileentity.ReassemblyUnitTileEntity;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ZygardeReassemblyPacket
extends AbstractPixelmonPacket {
    private BlockPos pos;
    private ReassemblyUnitTileEntity.Mode mode;
    private StoragePosition position;
    private int slot;

    public ZygardeReassemblyPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public ZygardeReassemblyPacket(BlockPos pos, ReassemblyUnitTileEntity.Mode mode, StoragePosition position, int slot) {
        super(PacketDirection.PLAY_SERVER, true);
        this.pos = pos;
        this.mode = mode;
        this.position = position;
        this.slot = slot;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.pos = BlockPos.m_122022_((long)buf.readLong());
        this.mode = ReassemblyUnitTileEntity.Mode.fromOrdinal(buf.readByte());
        this.position = buf.readBoolean() ? StoragePosition.decode((ByteBuf)buf) : null;
        this.slot = buf.readInt();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeLong(this.pos.m_121878_());
        buf.writeByte(this.mode.ordinal());
        buf.writeBoolean(this.position != null);
        if (this.position != null) {
            this.position.encode((ByteBuf)buf);
        }
        buf.writeInt(this.slot);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        Level world = context.getSender().m_9236_();
        ReassemblyUnitTileEntity assembly = BlockHelper.getTileEntity(ReassemblyUnitTileEntity.class, (LevelReader)world, this.pos);
        if (assembly != null) {
            assembly.onSelection(context.getSender(), this.mode, this.position, this.slot);
        }
    }
}

