/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.vendingMachine;

import com.pixelmonmod.pixelmon.api.economy.BankAccount;
import com.pixelmonmod.pixelmon.api.economy.BankAccountProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.blocks.machines.VendingMachineBlock;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopItemWithVariation;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class VendingMachinePacket
extends AbstractPixelmonPacket {
    private String itemID;
    private BlockPos pos;

    public VendingMachinePacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public VendingMachinePacket(BlockPos pos, String itemName) {
        super(PacketDirection.PLAY_SERVER, true);
        this.pos = pos;
        this.itemID = itemName;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        this.pos = new BlockPos(x, y, z);
        this.itemID = buf.m_130277_();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.pos.m_123341_());
        buf.writeInt(this.pos.m_123342_());
        buf.writeInt(this.pos.m_123343_());
        buf.m_130070_(this.itemID);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (!BlockHelper.validateReach(player, this.pos)) {
            return;
        }
        BlockState state = player.m_9236_().m_8055_(this.pos);
        BankAccount account = BankAccountProxy.getBankAccountNow(player);
        if (!(state.m_60734_() instanceof VendingMachineBlock) || account == null) {
            return;
        }
        ArrayList<ShopItemWithVariation> itemList = ((VendingMachineBlock)state.m_60734_()).getShop().getItems();
        for (ShopItemWithVariation s : itemList) {
            if (!s.getBaseShopItem().id.equals(this.itemID) || !account.hasBalance(s.getBuyCost())) continue;
            ItemStack item = s.getItemStack();
            ItemStack buyStack = item.m_41777_();
            buyStack.m_41764_(1);
            if (!player.m_36356_(buyStack)) continue;
            account.take(s.getBuyCost());
            player.f_36095_.m_38946_();
            player.m_6915_();
        }
    }
}

