/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.vendingMachine;

import com.pixelmonmod.pixelmon.client.gui.npc.AbstractShopScreen;
import com.pixelmonmod.pixelmon.client.gui.npc.ClientShopItem;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopItemWithVariation;
import java.util.ArrayList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SetVendingMachineDataPacket
extends AbstractPixelmonPacket {
    ArrayList<ShopItemWithVariation> buyList;
    ArrayList<ClientShopItem> clientBuyList;

    public SetVendingMachineDataPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public SetVendingMachineDataPacket(ArrayList<ShopItemWithVariation> buyList) {
        super(PacketDirection.PLAY_CLIENT);
        this.buyList = buyList;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeShort(this.buyList.size());
        for (ShopItemWithVariation item : this.buyList) {
            item.writeToBuffer(buffer);
        }
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        int numItems = buffer.readShort();
        this.clientBuyList = new ArrayList();
        for (int i = 0; i < numItems; ++i) {
            this.clientBuyList.add(ClientShopItem.fromBuffer(buffer));
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        AbstractShopScreen.buyItems = this.clientBuyList;
    }
}

