/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.trainerCard;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.client.gui.trainerCard.TrainerCardScreen;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.enums.EnumTrainerCardColor;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class TrainerCardPacket
extends AbstractPixelmonPacket {
    private UUID playerId;
    private EnumTrainerCardColor color;
    private BigDecimal money;
    private int caughtCount;
    private Pokemon[] party = new Pokemon[6];

    public TrainerCardPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public TrainerCardPacket(UUID playerId, EnumTrainerCardColor color, BigDecimal money, int caughtCount, Pokemon[] party) {
        super(PacketDirection.PLAY_CLIENT);
        this.playerId = playerId;
        this.color = color;
        this.money = money;
        this.caughtCount = caughtCount;
        this.party = party;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeLong(this.playerId.getMostSignificantBits());
        buf.writeLong(this.playerId.getLeastSignificantBits());
        buf.writeShort(this.color.ordinal());
        buf.m_130070_(this.money.toString());
        buf.writeInt(this.caughtCount);
        buf.writeShort(this.party.length);
        for (Pokemon poke : this.party) {
            boolean isPresent = poke != null;
            buf.writeBoolean(isPresent);
            if (!isPresent) continue;
            poke.writeToByteBuffer(buf, EnumUpdateType.Appearance);
        }
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.playerId = buf.m_130259_();
        this.color = EnumTrainerCardColor.values()[buf.readShort()];
        this.money = new BigDecimal(buf.m_130277_());
        this.caughtCount = buf.readInt();
        int length = buf.readShort();
        for (int i = 0; i < length; ++i) {
            if (!buf.readBoolean()) continue;
            this.party[i] = PokemonFactory.create(UUID.randomUUID()).readFromByteBuffer(buf, EnumUpdateType.Appearance);
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        if (Minecraft.m_91087_().f_91080_ instanceof TrainerCardScreen) {
            TrainerCardScreen gui = (TrainerCardScreen)Minecraft.m_91087_().f_91080_;
            if (gui.player.m_20148_().equals(this.playerId)) {
                gui.color = this.color;
                gui.money = NumberFormat.getInstance().format(this.money);
                gui.caughtCount = this.caughtCount;
                gui.party = this.party;
            }
        }
    }
}

