/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.trainerCard;

import com.pixelmonmod.pixelmon.api.economy.BankAccountProxy;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trainerCard.TrainerCardPacket;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class RequestTrainerCardPacket
extends AbstractPixelmonPacket {
    private UUID playerId;

    public RequestTrainerCardPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public RequestTrainerCardPacket(UUID playerId) {
        super(PacketDirection.PLAY_SERVER, true);
        this.playerId = playerId;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeLong(this.playerId.getMostSignificantBits());
        buf.writeLong(this.playerId.getLeastSignificantBits());
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.playerId = buf.m_130259_();
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender().m_20194_().m_6846_().m_11259_(this.playerId);
        if (player != null) {
            PlayerPartyStorage party = StorageProxy.getPartyNow(player);
            this.reply(context, new TrainerCardPacket(player.m_20148_(), party.trainerCardColor, BankAccountProxy.getBankAccountNow(player).getBalance(), party.playerPokedex.countCaught(), StorageProxy.getPartyNow(player).getAll()));
        }
    }
}

