/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.trading;

import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.trading.TradePair;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SetClientTradePairPacket
extends AbstractPixelmonPacket {
    private TradePair tradePair;
    private boolean hasPokemon = false;

    public SetClientTradePairPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public SetClientTradePairPacket(TradePair tradePair, boolean hasPokemon) {
        super(PacketDirection.PLAY_CLIENT);
        this.tradePair = tradePair;
        this.hasPokemon = hasPokemon;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        PokemonSpecification offer = PokemonSpecificationProxy.fromNbt(buf.m_130260_()).get();
        PokemonSpecification exchange = PokemonSpecificationProxy.fromNbt(buf.m_130260_()).get();
        String description = buf.m_130277_();
        if (description.equals("null")) {
            description = null;
        }
        this.tradePair = new TradePair(offer, exchange, description);
        this.hasPokemon = buf.readBoolean();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130079_((Tag)this.tradePair.offer.write(new CompoundTag()));
        buf.m_130079_((Tag)this.tradePair.exchange.write(new CompoundTag()));
        buf.m_130070_(this.tradePair.description == null || this.tradePair.description.isEmpty() ? "null" : this.tradePair.description);
        buf.writeBoolean(this.hasPokemon);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ClientProxy.currentTradePair = this.tradePair;
        ClientProxy.playerHasTradeRequestPokemon = this.hasPokemon;
    }
}

