/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.trading;

import com.pixelmonmod.pixelmon.blocks.tileentity.TradeMachineTileEntity;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trading.EnumServerTradesMode;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ServerTradesPacket
extends AbstractPixelmonPacket {
    private EnumServerTradesMode mode;
    private int pos = 0;
    private boolean ready = false;
    private BlockPos tradeMachine;

    public ServerTradesPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public ServerTradesPacket(EnumServerTradesMode mode, BlockPos tradeMachine) {
        super(PacketDirection.PLAY_SERVER);
        this.mode = mode;
        this.tradeMachine = tradeMachine;
    }

    public static ServerTradesPacket getTradePacket(BlockPos tradeMachine) {
        return new ServerTradesPacket(EnumServerTradesMode.Trade, tradeMachine);
    }

    public static ServerTradesPacket getDeRegisterPacket(BlockPos tradeMachine) {
        return new ServerTradesPacket(EnumServerTradesMode.DeRegisterTrader, tradeMachine);
    }

    public ServerTradesPacket(int pos, BlockPos tradeMachine) {
        this(EnumServerTradesMode.SelectPokemon, tradeMachine);
        this.pos = pos;
    }

    public ServerTradesPacket(boolean ready, BlockPos tradeMachine) {
        this(EnumServerTradesMode.Ready, tradeMachine);
        this.ready = ready;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeShort(this.mode.ordinal());
        buffer.writeInt(this.pos);
        buffer.writeBoolean(this.ready);
        buffer.writeLong(this.tradeMachine.m_121878_());
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        short ind = buffer.readShort();
        for (EnumServerTradesMode m : EnumServerTradesMode.values()) {
            if (m.ordinal() != ind) continue;
            this.mode = m;
        }
        this.pos = buffer.readInt();
        this.ready = buffer.readBoolean();
        this.tradeMachine = BlockPos.m_122022_((long)buffer.readLong());
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        BlockPos p;
        ServerPlayer player = context.getSender();
        if (player.m_20275_((double)(p = this.tradeMachine).m_123341_() + 0.5, (double)p.m_123342_() + 0.5, (double)p.m_123343_() + 0.5) <= 64.0) {
            context.enqueueWork(() -> {
                BlockEntity te = player.m_9236_().m_7702_(p);
                if (te instanceof TradeMachineTileEntity) {
                    TradeMachineTileEntity tradeMachine = (TradeMachineTileEntity)te;
                    if (this.mode == EnumServerTradesMode.SelectPokemon) {
                        if (tradeMachine.player1 == player) {
                            tradeMachine.setPos1(this.pos);
                        } else if (tradeMachine.player2 == player) {
                            tradeMachine.setPos2(this.pos);
                        }
                    } else if (this.mode == EnumServerTradesMode.DeRegisterTrader) {
                        tradeMachine.removePlayer((Player)player);
                    } else if (this.mode == EnumServerTradesMode.Ready) {
                        tradeMachine.ready((Player)player, this.ready);
                    } else if (this.mode == EnumServerTradesMode.Trade) {
                        tradeMachine.trade();
                    }
                }
            });
        }
    }
}

