/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.sync;

import com.google.gson.JsonElement;
import com.pixelmonmod.pixelmon.api.config.BetterSpawnerConfig;
import com.pixelmonmod.pixelmon.api.spawning.SpawnSet;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SyncSpawningPacket
extends AbstractPixelmonPacket {
    private static final int MAX_STRING_LENGTH = Short.MAX_VALUE;

    public SyncSpawningPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public static void sync(ServerPlayer player) {
        NetworkHelper.sendPacket(player, new SyncSpawningPacket());
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        int totalSize = BetterSpawnerConfig.getStoredJson().length();
        int numStrings = totalSize / Short.MAX_VALUE;
        buffer.writeInt(numStrings + 1);
        for (int stringCount = 0; stringCount < numStrings; ++stringCount) {
            int start = stringCount * Short.MAX_VALUE;
            int end = (stringCount + 1) * Short.MAX_VALUE;
            String substring = BetterSpawnerConfig.getStoredJson().substring(start, end);
            buffer.m_130070_(substring);
        }
        String endString = BetterSpawnerConfig.getStoredJson().substring(numStrings * Short.MAX_VALUE);
        buffer.m_130070_(endString);
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        int stringCount = buffer.readInt();
        StringBuilder json = new StringBuilder();
        for (int stringIndex = 0; stringIndex < stringCount; ++stringIndex) {
            json.append(buffer.m_130277_());
        }
        BetterSpawnerConfig.load(SpawnSet.GSON, (JsonElement)SpawnSet.GSON.fromJson(json.toString(), JsonElement.class));
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
    }
}

