/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.sync;

import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SyncNPCsPacket
extends AbstractPixelmonPacket {
    private int totalPackets;
    private int index;

    public SyncNPCsPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public SyncNPCsPacket(int totalPackets, int index) {
        this();
        this.index = index;
        this.totalPackets = totalPackets;
    }

    public static void sync(ServerPlayer player) {
        for (int i = 0; i < 10; ++i) {
            NetworkHelper.sendPacket(player, new SyncNPCsPacket(10, i));
        }
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        ServerNPCRegistry.decodeNPCs(buffer);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        ServerNPCRegistry.encodeNPCs(buffer, this.index, this.totalPackets);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
    }
}

