/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.sync;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.CommonProxy;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SyncMovesPacket
extends AbstractPixelmonPacket {
    private List<ImmutableAttack> moves;

    public SyncMovesPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    private SyncMovesPacket(List<ImmutableAttack> moves) {
        this();
        this.moves = moves;
    }

    public static void sync(ServerPlayer player) {
        List<ImmutableAttack> moves = AttackRegistry.getAllAttacks();
        int groups = Math.max(1, moves.size() / 100);
        int size = moves.size() / groups;
        for (int group = 0; group < groups; ++group) {
            ArrayList sublist = Lists.newArrayList();
            if (group + 1 == groups) {
                for (i = size * group; i < moves.size(); ++i) {
                    sublist.add(moves.get(i));
                }
            } else {
                for (i = size * group; i < size * (group + 1); ++i) {
                    sublist.add(moves.get(i));
                }
            }
            NetworkHelper.sendPacket(player, new SyncMovesPacket(sublist));
        }
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.moves = Lists.newArrayList();
        int count = buffer.readInt();
        for (int i = 0; i < count; ++i) {
            String json = buffer.m_130277_();
            ImmutableAttack attack = (ImmutableAttack)AttackRegistry.GSON.fromJson(json, ImmutableAttack.class);
            attack.setJson(json);
            attack.setResourceLocation(buffer.m_130281_());
            AttackRegistry.addAttack(attack, attack.getResourceLocation(), attack.getJson());
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.moves.size());
        for (ImmutableAttack attack : this.moves) {
            buffer.m_130070_(attack.getJson());
            buffer.m_130085_(attack.getResourceLocation());
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        CommonProxy.loadDefaultMoveSkills();
        ClientProxy.moveSkills.clear();
        ClientProxy.moveSkills.addAll(MoveSkill.moveSkills);
    }
}

