/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.sync;

import com.pixelmonmod.api.loader.DataSyncLock;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class DataSyncControlPacket
extends AbstractPixelmonPacket {
    private String context;
    private boolean lock;
    private long timeout;

    public DataSyncControlPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public DataSyncControlPacket(String context, boolean lock, long timeout) {
        this();
        this.context = context;
        this.lock = lock;
        this.timeout = timeout;
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.context = buffer.m_130277_();
        this.lock = buffer.readBoolean();
        if (this.lock) {
            this.timeout = buffer.readLong();
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.context);
        buffer.writeBoolean(this.lock);
        if (this.lock) {
            buffer.writeLong(this.timeout);
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        if (this.lock) {
            DataSyncLock.acquire(this.context, this.timeout);
        } else {
            DataSyncLock.release(this.context);
        }
    }
}

