/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.statueEditor;

import com.pixelmonmod.pixelmon.api.util.helpers.DimensionHelper;
import com.pixelmonmod.pixelmon.blocks.tileentity.PokeDisplayTileEntity;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.statueEditor.EnumStatuePacketMode;
import com.pixelmonmod.pixelmon.enums.EnumStatueTextureType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class PokeDisplayUpdatePacket
extends AbstractPixelmonPacket {
    private EnumStatuePacketMode mode;
    private PokeDisplayTileEntity id;
    private String name;
    private boolean data;
    private int intData;

    public PokeDisplayUpdatePacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public PokeDisplayUpdatePacket(EnumStatuePacketMode mode, PokeDisplayTileEntity id, String name) {
        super(PacketDirection.PLAY_SERVER, true);
        this.mode = mode;
        this.id = id;
        this.name = name;
    }

    public PokeDisplayUpdatePacket(EnumStatuePacketMode mode, PokeDisplayTileEntity id, boolean data) {
        super(PacketDirection.PLAY_SERVER, true);
        this.mode = mode;
        this.id = id;
        this.data = data;
    }

    public PokeDisplayUpdatePacket(EnumStatuePacketMode mode, PokeDisplayTileEntity id, int intData) {
        super(PacketDirection.PLAY_SERVER, true);
        this.mode = mode;
        this.id = id;
        this.intData = intData;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.mode = EnumStatuePacketMode.getFromOrdinal(buf.readShort());
        ServerLevel world = ServerLifecycleHooks.getCurrentServer().m_129880_(DimensionHelper.getDimension(buf.m_130281_()));
        this.id = (PokeDisplayTileEntity)world.m_7702_(buf.m_130135_());
        switch (this.mode) {
            case SetGrowth: 
            case SetLabel: 
            case SetTextureType: 
            case SetAnimation: 
            case SetName: 
            case SetPalette: 
            case SetBoundingBoxMode: 
            case SetForm: {
                this.name = buf.m_130277_();
                break;
            }
            case SetShouldAnimate: 
            case SetModelStanding: 
            case SetCanMove: {
                this.data = buf.readBoolean();
                break;
            }
            case SetAnimationFrame: 
            case SetGender: 
            case SET_SPECIES: {
                this.intData = buf.readInt();
            }
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeShort((int)((short)this.mode.ordinal()));
        buf.m_130085_(this.id.m_58904_().m_46472_().m_135782_());
        buf.m_130064_(this.id.m_58899_());
        switch (this.mode) {
            case SetGrowth: 
            case SetLabel: 
            case SetTextureType: 
            case SetAnimation: 
            case SetName: 
            case SetPalette: 
            case SetBoundingBoxMode: 
            case SetForm: {
                buf.m_130070_(this.name);
                break;
            }
            case SetShouldAnimate: 
            case SetModelStanding: 
            case SetCanMove: {
                buf.writeBoolean(this.data);
                break;
            }
            case SetAnimationFrame: 
            case SetGender: 
            case SET_SPECIES: {
                buf.writeInt(this.intData);
            }
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer sender = context.getSender();
        Object value = this.mode.chooseValueForMode(this.name, this.data, this.intData);
        switch (this.mode) {
            case SetLabel: {
                this.id.setLabel((String)value);
                break;
            }
            case SetTextureType: {
                this.id.setTextureMode(EnumStatueTextureType.getFromString((String)value));
                break;
            }
            case SetAnimation: {
                this.id.setAnimation(AnimationType.getTypeFor((String)value));
                break;
            }
            case SetModelStanding: {
                this.id.setFlying((Boolean)value);
                break;
            }
            case SetAnimationFrame: {
                this.id.setAnimationFrame((Integer)value);
                break;
            }
            case SetForm: {
                this.id.getStoredEntity().setForm((String)value);
                break;
            }
            case SetShouldAnimate: {
                this.id.setAnimate((Boolean)value);
            }
        }
        this.id.m_6596_();
    }
}

