/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.statueEditor;

import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.blocks.tileentity.PokeDisplayTileEntity;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class PokeDisplaySwapPacket
extends AbstractPixelmonPacket {
    private BlockPos pos;
    private int newSlot;

    public PokeDisplaySwapPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public PokeDisplaySwapPacket(BlockPos pos, int newSlot) {
        this();
        this.pos = pos;
        this.newSlot = newSlot;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeInt(this.newSlot);
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.newSlot = buffer.readInt();
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            PokeDisplayTileEntity tileEntity = (PokeDisplayTileEntity)sender.m_9236_().m_7702_(this.pos);
            PlayerPartyStorage party = StorageProxy.getPartyNow(sender);
            if (!tileEntity.isLockedBy((Player)sender)) {
                return;
            }
            if (this.newSlot != -1) {
                tileEntity.getStoredPoke().ifPresent(party::add);
                tileEntity.setStoredPoke(party.get(this.newSlot));
                party.set(this.newSlot, null);
            }
            tileEntity.setLocked(null);
        });
    }
}

