/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.selection;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.client.gui.custom.selection.SelectionScreen;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SetSelectionOptionsPacket
extends AbstractPixelmonPacket {
    private int slot;
    private Pokemon pokemon;

    public SetSelectionOptionsPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public SetSelectionOptionsPacket(int slot, Pokemon pokemon) {
        this();
        this.slot = slot;
        this.pokemon = pokemon;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.slot = buf.readInt();
        this.pokemon = PokemonFactory.create(UUID.randomUUID()).readFromByteBuffer(buf, EnumUpdateType.ALL);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.slot);
        this.pokemon.writeToByteBuffer(buf, EnumUpdateType.ALL);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        this.onClient(context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onClient(CustomPayloadEvent.Context context) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (!(screen instanceof SelectionScreen)) {
            return;
        }
        ((SelectionScreen)screen).setPokemon(this.slot, this.pokemon);
        ((SelectionScreen)screen).m_7856_();
    }
}

