/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.selection;

import com.pixelmonmod.pixelmon.client.gui.custom.selection.SelectionScreen;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class OpenSelectionPacket
extends AbstractPixelmonPacket {
    private Component title;
    private Component text;
    private int selections;
    private boolean allowExit;

    public OpenSelectionPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public OpenSelectionPacket(Component title, Component text, int selections, boolean allowExit) {
        this();
        this.title = title;
        this.text = text;
        this.selections = selections;
        this.allowExit = allowExit;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.title = buf.m_130238_();
        this.text = buf.m_130238_();
        this.selections = buf.readInt();
        this.allowExit = buf.readBoolean();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130083_(this.title);
        buf.m_130083_(this.text);
        buf.writeInt(this.selections);
        buf.writeBoolean(this.allowExit);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        this.onClient(context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onClient(CustomPayloadEvent.Context context) {
        Minecraft.m_91087_().m_91152_((Screen)new SelectionScreen(this.title, this.text, this.selections, this.allowExit));
    }
}

