/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.raids;

import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.raids.RaidData;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.raids.CloseRaidPacket;
import com.pixelmonmod.pixelmon.entities.DenEntity;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class RaidActionPacket
extends AbstractPixelmonPacket {
    private int den;
    private int action;
    private int slot;
    private ItemStack usedStack = null;
    private int stackCount;

    public RaidActionPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public RaidActionPacket(int den, int action) {
        this(den, action, 0);
    }

    public RaidActionPacket(int den, int action, int slot) {
        this();
        this.den = den;
        this.action = action;
        this.slot = slot;
    }

    public RaidActionPacket(int den, int action, int slot, ItemStack usedStack) {
        this();
        this.den = den;
        this.action = action;
        this.slot = slot;
        this.usedStack = usedStack;
        if (this.usedStack != null) {
            this.stackCount = this.usedStack.m_41613_();
            this.usedStack.m_41764_(1);
        }
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.den = buf.readInt();
        this.action = buf.readInt();
        this.slot = buf.readInt();
        if (buf.readBoolean()) {
            this.usedStack = buf.m_130267_();
            this.stackCount = buf.readInt();
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.den);
        buf.writeInt(this.action);
        buf.writeInt(this.slot);
        buf.writeBoolean(this.usedStack != null);
        if (this.usedStack != null) {
            buf.m_130055_(this.usedStack);
            buf.writeInt(this.stackCount);
        }
    }

    @Override
    public void handlePacket(CustomPayloadEvent.Context context) {
        ServerLifecycleHooks.getCurrentServer().execute(() -> {
            ServerLevel world;
            Entity entity;
            ServerPlayer player = context.getSender();
            if (player != null && (entity = (world = player.m_284548_()).m_6815_(this.den)) instanceof DenEntity) {
                DenEntity den = (DenEntity)entity;
                RaidData raid = den.getServerData();
                if ((raid == null || raid.getPlayer(player) == null) && (raid = den.getInUseRaidData()) != null && raid.getPlayer(player) == null) {
                    raid = null;
                }
                if (raid != null) {
                    if (den.m_20270_((Entity)player) <= 30.0f) {
                        if (this.usedStack != null && this.stackCount > 0) {
                            this.usedStack.m_41764_(this.stackCount);
                        }
                        raid.processAction(this.action, this.slot, this.usedStack, player);
                    } else {
                        raid.removePlayer(player);
                    }
                } else {
                    NetworkHelper.sendPacket(new CloseRaidPacket(), player);
                }
            }
        });
    }
}

