/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.PokemonEditorPartyScreen;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.UpdateEditedPokemonPacket;
import com.pixelmonmod.pixelmon.items.PokemonEditorItem;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class UpdatePlayerPokemonPacket
extends UpdateEditedPokemonPacket {
    private UUID playerUUID;

    public UpdatePlayerPokemonPacket() {
    }

    public UpdatePlayerPokemonPacket(Pokemon data) {
        super(data);
        this.playerUUID = PokemonEditorPartyScreen.editedPlayerUUID;
    }

    public UpdatePlayerPokemonPacket(Pokemon data, int slot) {
        super(data, slot);
        this.playerUUID = PokemonEditorPartyScreen.editedPlayerUUID;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.m_130077_(this.playerUUID);
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        super.decode(buffer);
        this.playerUUID = buffer.m_130259_();
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer sender = context.getSender();
        if (!PokemonEditorItem.checkPermission(sender)) {
            return;
        }
        ServerPlayer player = sender.m_20194_().m_6846_().m_11259_(this.playerUUID);
        if (player != null) {
            PlayerPartyStorage party = StorageProxy.getPartyNow(player);
            int slot = party.getSlot(this.data);
            if (this.slot == -1) {
                if (slot == -1) {
                    party.add(this.data);
                } else {
                    party.set(party.getSlot(this.data), this.data);
                }
            }
            UpdatePlayerPokemonPacket.updatePokemon(this, player, party);
            PokemonEditorItem.updateSinglePokemon(sender, this.playerUUID, party.getSlot(this.data));
        }
    }
}

