/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.PartyEditorBaseScreen;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SetImportPokemonIDPacket
extends AbstractPixelmonPacket {
    int partySlot;
    UUID pokemonUUID;

    public SetImportPokemonIDPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public SetImportPokemonIDPacket(int partySlot, UUID pokemonUUID) {
        super(PacketDirection.PLAY_CLIENT);
        this.partySlot = partySlot;
        this.pokemonUUID = pokemonUUID;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.partySlot);
        buf.m_130077_(this.pokemonUUID);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.partySlot = buf.readInt();
        this.pokemonUUID = buf.m_130259_();
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        Pokemon pokemon = null;
        Screen currentScreen = Minecraft.m_91087_().f_91080_;
        List<Pokemon> pokemonList = null;
        if (currentScreen instanceof PartyEditorBaseScreen) {
            PartyEditorBaseScreen partyEditor = (PartyEditorBaseScreen)currentScreen;
            pokemonList = partyEditor.pokemonList;
        } else {
            pokemonList = ServerStorageDisplay.editedPokemon;
        }
        if (pokemonList != null && pokemonList.size() > this.partySlot) {
            pokemon = pokemonList.get(this.partySlot);
        }
        if (pokemon != null) {
            pokemon.setUUID(this.pokemonUUID);
        }
    }
}

