/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.PokemonEditorPartyScreen;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SetEditedPlayerPacket
extends AbstractPixelmonPacket {
    private UUID playerID;
    private String playerName;
    private Pokemon[] pokemon;

    public SetEditedPlayerPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public SetEditedPlayerPacket(UUID playerID, Pokemon[] pokemon) {
        this(playerID, "", pokemon);
    }

    public SetEditedPlayerPacket(UUID playerID, String playerName, Pokemon[] pokemon) {
        super(PacketDirection.PLAY_CLIENT);
        this.playerID = playerID;
        this.playerName = playerName;
        this.pokemon = pokemon;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.playerID);
        buf.m_130070_(this.playerName);
        for (Pokemon data : this.pokemon) {
            if (data == null) {
                buf.writeBoolean(false);
                continue;
            }
            buf.writeBoolean(true);
            data.writeToByteBuffer(buf, EnumUpdateType.ALL);
        }
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.playerID = buf.m_130259_();
        this.playerName = buf.m_130277_();
        this.pokemon = new Pokemon[6];
        for (int i = 0; i < this.pokemon.length; ++i) {
            if (!buf.readBoolean()) continue;
            this.pokemon[i] = PokemonFactory.create(UUID.randomUUID()).readFromByteBuffer(buf, EnumUpdateType.ALL);
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        PokemonEditorPartyScreen.editedPlayerUUID = this.playerID;
        if (!this.playerName.isEmpty()) {
            PokemonEditorPartyScreen.editedPlayerName = this.playerName;
        }
        ServerStorageDisplay.editedPokemon = Arrays.asList(this.pokemon);
        for (Pokemon pokemon1 : this.pokemon) {
            if (pokemon1 == null) continue;
            Ability ability = pokemon1.getAbility();
            boolean bl = false;
        }
    }
}

