/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor;

import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.SetEditedPlayerPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.SetEditingPlayerPacket;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.items.PokemonEditorItem;
import java.util.UUID;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class RespondPokemonEditorAllowed
extends AbstractPixelmonPacket {
    private UUID editingPlayer;
    private boolean allowPokemonEditors;

    public RespondPokemonEditorAllowed() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public RespondPokemonEditorAllowed(UUID editingPlayer, boolean allowPokemonEditors) {
        super(PacketDirection.PLAY_SERVER, true);
        this.editingPlayer = editingPlayer;
        this.allowPokemonEditors = allowPokemonEditors;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.editingPlayer);
        buf.writeBoolean(this.allowPokemonEditors);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.editingPlayer = buf.m_130259_();
        this.allowPokemonEditors = buf.readBoolean();
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        MinecraftServer server = context.getSender().m_20194_();
        ServerPlayer editingPlayer = server.m_6846_().m_11259_(this.editingPlayer);
        ServerPlayer editedPlayer = context.getSender();
        if (editingPlayer != null) {
            if (!PokemonEditorItem.checkPermission(editingPlayer)) {
                return;
            }
            if (this.allowPokemonEditors) {
                PlayerPartyStorage party = StorageProxy.getPartyNow(editedPlayer);
                party.retrieveAll("PokemonEditor");
                NetworkHelper.sendPacket(new SetEditingPlayerPacket(editingPlayer.m_20148_(), editingPlayer.m_5446_().getString()), editedPlayer);
                OpenScreenPacket.open((Player)editedPlayer, EnumGuiScreen.EditedPlayer, new int[0]);
                NetworkHelper.sendPacket(new SetEditedPlayerPacket(editedPlayer.m_20148_(), editedPlayer.m_5446_().getString(), party.getAll()), editingPlayer);
                OpenScreenPacket.open((Player)editingPlayer, EnumGuiScreen.PokemonEditor, new int[0]);
            } else {
                ChatHandler.sendChat((Entity)editingPlayer, I18n.m_118938_((String)"gui.pokemoneditor.notallowedplayer", (Object[])new Object[]{editedPlayer.m_5446_().getString()}), new Object[0]);
            }
        }
    }
}

