/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor;

import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.CloseEditedPlayerPacket;
import com.pixelmonmod.pixelmon.items.PokemonEditorItem;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class RequestCloseEditedPlayerPacket
extends AbstractPixelmonPacket {
    private UUID editedPlayer;

    public RequestCloseEditedPlayerPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public RequestCloseEditedPlayerPacket(UUID editedPlayer) {
        super(PacketDirection.PLAY_SERVER, true);
        this.editedPlayer = editedPlayer;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.editedPlayer);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.editedPlayer = buf.m_130259_();
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        if (!PokemonEditorItem.checkPermission(context.getSender())) {
            return;
        }
        ServerPlayer editedPlayer = context.getSender().m_20194_().m_6846_().m_11259_(this.editedPlayer);
        if (editedPlayer != null) {
            NetworkHelper.sendPacket(new CloseEditedPlayerPacket(), editedPlayer);
        }
    }
}

