/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor;

import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.items.PokemonEditorItem;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class RandomizePokemonPacket
extends AbstractPixelmonPacket {
    private UUID playerID;

    public RandomizePokemonPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public RandomizePokemonPacket(UUID playerUUID) {
        super(PacketDirection.PLAY_SERVER, true);
        this.playerID = playerUUID;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.playerID);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.playerID = buf.m_130259_();
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        if (!PokemonEditorItem.checkPermission(context.getSender())) {
            return;
        }
        PlayerPartyStorage party = StorageProxy.getPartyNow(this.playerID);
        for (int i = 0; i < 6; ++i) {
            party.set(i, PokemonFactory.create(PixelmonSpecies.getRandomSpecies()));
        }
        PokemonEditorItem.updateEditedPlayer(context.getSender(), this.playerID);
    }
}

