/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor;

import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.PokemonEditorPartyScreen;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.items.PokemonEditorItem;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class DeletePokemonPacket
extends AbstractPixelmonPacket {
    private UUID playerID;
    private UUID pokemonUUID;

    public DeletePokemonPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public DeletePokemonPacket(UUID pokemonUUID) {
        super(PacketDirection.PLAY_SERVER, true);
        this.playerID = PokemonEditorPartyScreen.editedPlayerUUID;
        this.pokemonUUID = pokemonUUID;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.playerID);
        buf.m_130077_(this.pokemonUUID);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.playerID = buf.m_130259_();
        this.pokemonUUID = buf.m_130259_();
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        PlayerPartyStorage party;
        int slot;
        if (PokemonEditorItem.checkPermission(context.getSender()) && (slot = (party = StorageProxy.getPartyNow(this.playerID)).getSlot(this.pokemonUUID)) != -1) {
            DeletePokemonPacket.deletePokemon(this.playerID, slot, context);
        }
    }

    public static void deletePokemon(UUID playerID, int slot, CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        PlayerPartyStorage party = StorageProxy.getPartyNow(playerID);
        party.set(slot, null);
        PokemonEditorItem.updateSinglePokemon(player, playerID, slot);
    }
}

