/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor;

import com.pixelmonmod.pixelmon.api.pokemon.InitializeCategory;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.PokemonEditorPartyScreen;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.items.PokemonEditorItem;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ChangePokemonPacket
extends AbstractPixelmonPacket {
    private UUID playerID;
    private UUID pokemonUUID;
    private Species newPokemon;

    public ChangePokemonPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public ChangePokemonPacket(UUID pokemonUUID, Species newPokemon) {
        super(PacketDirection.PLAY_SERVER, true);
        this.playerID = PokemonEditorPartyScreen.editedPlayerUUID;
        this.pokemonUUID = pokemonUUID;
        this.newPokemon = newPokemon;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.playerID);
        buf.m_130077_(this.pokemonUUID);
        buf.writeInt(this.newPokemon.getDex());
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.playerID = buf.m_130259_();
        this.pokemonUUID = buf.m_130259_();
        this.newPokemon = PixelmonSpecies.fromNationalDex(buf.readInt());
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (!PokemonEditorItem.checkPermission(player)) {
            return;
        }
        PlayerPartyStorage party = StorageProxy.getPartyNow(this.playerID);
        Pokemon pokemon = party.find(this.pokemonUUID);
        if (pokemon == null) {
            pokemon = PokemonFactory.create(this.newPokemon).initialize(InitializeCategory.SPECIES, InitializeCategory.INTRINSIC_FORCEFUL).setUUID(this.pokemonUUID);
            party.add(pokemon);
        } else {
            pokemon.setSpecies(this.newPokemon, true);
            pokemon.initialize(InitializeCategory.SPECIES, InitializeCategory.INTRINSIC_FORCEFUL);
        }
        int slot = party.getSlot(pokemon);
        PokemonEditorItem.updateSinglePokemon(player, this.playerID, slot);
    }
}

