/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.pokedex;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.PokedexEvent;
import com.pixelmonmod.pixelmon.api.pokedex.PlayerPokedex;
import com.pixelmonmod.pixelmon.api.pokedex.PokedexRegistrationStatus;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ServerPokedexPacket
extends AbstractPixelmonPacket {
    private boolean launch;
    private int entityID;

    public ServerPokedexPacket(boolean launch, int entityID) {
        super(PacketDirection.PLAY_SERVER, true);
        this.launch = launch;
        this.entityID = entityID;
    }

    public ServerPokedexPacket(boolean launch) {
        this(launch, -1);
    }

    public ServerPokedexPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.launch);
        if (this.launch) {
            buf.writeInt(this.entityID);
        }
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.launch = buf.readBoolean();
        if (this.launch) {
            this.entityID = buf.readInt();
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        Entity entity;
        ServerPlayer player = context.getSender();
        PlayerPartyStorage party = StorageProxy.getPartyNow(player);
        PlayerPokedex playerPokedex = party.playerPokedex;
        boolean hasChanged = false;
        int id = 1;
        if (this.launch && this.entityID >= 0 && (entity = player.m_9236_().m_6815_(this.entityID)) instanceof PixelmonEntity && entity.m_20270_((Entity)player) < 20.0f) {
            Pokemon pokemon = ((PixelmonEntity)entity).getPokemon();
            PokedexEvent.Pre preEvent = new PokedexEvent.Pre(player.m_20148_(), pokemon, PokedexRegistrationStatus.SEEN, "pokedexKey");
            if (!Pixelmon.EVENT_BUS.post((Event)preEvent)) {
                hasChanged = playerPokedex.set(preEvent.getPokemon(), preEvent.getNewStatus());
                id = pokemon.getSpecies().getDex();
                Pixelmon.EVENT_BUS.post((Event)new PokedexEvent.Post(player.m_20148_(), preEvent.getOldStatus(), preEvent.getPokemon(), preEvent.getNewStatus(), preEvent.getCause()));
            }
        }
        if (hasChanged) {
            playerPokedex.update();
        }
        if (this.launch) {
            OpenScreenPacket.open((Player)player, EnumGuiScreen.Pokedex, id);
        }
    }
}

