/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.pokedex;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokedex.PlayerPokedex;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SendSpawnDataPacket
extends AbstractPixelmonPacket {
    private List<PlayerPokedex.PokedexSpawnData> spawnData = Lists.newArrayList();
    private int dex;

    public SendSpawnDataPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public SendSpawnDataPacket(int dex, List<PlayerPokedex.PokedexSpawnData> data) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.dex = dex;
        this.spawnData = data;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.dex);
        buf.writeInt(this.spawnData.size());
        for (PlayerPokedex.PokedexSpawnData data : this.spawnData) {
            data.encryptTo(buf);
        }
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.dex = buf.readInt();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.spawnData.add(PlayerPokedex.PokedexSpawnData.decryptFrom(buf));
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ClientStorageManager.pokedex.update(this.dex, this.spawnData);
    }
}

