/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.pokedex;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokedex.PlayerPokedex;
import com.pixelmonmod.pixelmon.api.pokedex.PokedexRegistrationStatus;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnSet;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.world.WeatherType;
import com.pixelmonmod.pixelmon.api.world.WorldTime;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokedex.SendSpawnDataPacket;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagEntry;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class RequestSpawnDataPacket
extends AbstractPixelmonPacket {
    private int dex;

    public RequestSpawnDataPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public RequestSpawnDataPacket(int dex) {
        super(PacketDirection.PLAY_SERVER, true);
        this.dex = dex;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.dex);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.dex = buf.readInt();
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        PokedexRegistrationStatus status = StorageProxy.getPartyNow((ServerPlayer)context.getSender()).playerPokedex.get(this.dex);
        ArrayList spawnData = Lists.newArrayList();
        if (status != PokedexRegistrationStatus.UNKNOWN) {
            List<SpawnSet> spawns;
            Species species = PixelmonSpecies.fromNationalDex(this.dex);
            List<SpawnSet> list = spawns = PixelmonSpecies.getLegendaries().stream().anyMatch(e -> species.getDex() == e.intValue()) ? PixelmonSpawning.legendaries : PixelmonSpawning.standard;
            if (species != null) {
                for (SpawnSet spawn : spawns) {
                    if (!spawn.id.equalsIgnoreCase(species.getName())) continue;
                    for (SpawnInfo info : spawn.spawnInfos) {
                        if (info == null || info.condition == null || info.condition.biomes == null) continue;
                        for (TagEntry biome : info.condition.biomes) {
                            PlayerPokedex.PokedexSpawnData data = new PlayerPokedex.PokedexSpawnData(biome.toString());
                            if (info.condition.times != null) {
                                for (WorldTime time : info.condition.times) {
                                    data.addTime(time);
                                }
                            }
                            if (info.condition.cachedWeathers != null) {
                                for (WeatherType weather : info.condition.cachedWeathers) {
                                    data.addWeather(weather);
                                }
                            }
                            if (info.condition.maxY != null) {
                                data.setMaxY(info.condition.maxY);
                            }
                            if (info.condition.minY != null) {
                                data.setMinY(info.condition.minY);
                            }
                            spawnData.add(data);
                        }
                    }
                }
            }
        }
        this.reply(context, new SendSpawnDataPacket(this.dex, spawnData));
    }
}

