/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.TrainerPartyStorage;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.TrainerEditorScreen;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.UpdateEditedPokemonPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.items.NPCEditorItem;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class UpdateTrainerPokemonPacketPacket
extends UpdateEditedPokemonPacket {
    public int trainerID;

    public UpdateTrainerPokemonPacketPacket() {
    }

    public UpdateTrainerPokemonPacketPacket(Pokemon data) {
        super(data);
        this.trainerID = TrainerEditorScreen.currentTrainerID;
    }

    public UpdateTrainerPokemonPacketPacket(Pokemon data, int slot) {
        super(data, slot);
        this.trainerID = TrainerEditorScreen.currentTrainerID;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.trainerID);
        super.encode(buffer);
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.trainerID = buffer.readInt();
        super.decode(buffer);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (!NPCEditorItem.checkPermission((Player)player)) {
            return;
        }
        Optional<NPCTrainer> entityNPCOptional = NPCEntity.locateNPCServer(player.m_9236_(), this.trainerID, NPCTrainer.class);
        if (!entityNPCOptional.isPresent()) {
            return;
        }
        NPCTrainer t = entityNPCOptional.get();
        TrainerPartyStorage storage = t.getPokemonStorage();
        UpdateTrainerPokemonPacketPacket.updatePokemon(this, player, storage);
        if (this.data != null) {
            t.updateTrainerLevel();
            storage.sendCacheToPlayer(player);
        }
    }
}

