/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.TrainerPartyStorage;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.DeleteTrainerPokemonPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.UpdateTrainerPokemonPacketPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.UpdateEditedPartyPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.UpdateEditedPokemonPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.items.NPCEditorItem;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class UpdateTrainerPartyPacketPacket
extends UpdateEditedPartyPacket {
    private int trainerID;

    public UpdateTrainerPartyPacketPacket() {
    }

    public UpdateTrainerPartyPacketPacket(List<Pokemon> party) {
        super(party);
    }

    @Override
    protected UpdateEditedPokemonPacket createPokemonPacket(Pokemon data) {
        return new UpdateTrainerPokemonPacketPacket(data);
    }

    @Override
    protected UpdateEditedPokemonPacket readPokemonData(FriendlyByteBuf buf) {
        UpdateTrainerPokemonPacketPacket data = new UpdateTrainerPokemonPacketPacket();
        data.decode(buf);
        this.trainerID = data.trainerID;
        return data;
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (!NPCEditorItem.checkPermission((Player)player)) {
            return;
        }
        Optional<NPCTrainer> entityNPCOptional = NPCEntity.locateNPCServer(context.getSender().m_9236_(), this.trainerID, NPCTrainer.class);
        if (!entityNPCOptional.isPresent()) {
            return;
        }
        NPCTrainer t = entityNPCOptional.get();
        TrainerPartyStorage storage = t.getPokemonStorage();
        for (int i = 0; i < 6; ++i) {
            storage.set(i, null);
        }
        UpdateTrainerPokemonPacketPacket handler = new UpdateTrainerPokemonPacketPacket();
        int numPokemon = this.party.size();
        for (int i = 0; i < 6; ++i) {
            UpdateTrainerPokemonPacketPacket data = null;
            if (i < numPokemon) {
                data = (UpdateTrainerPokemonPacketPacket)this.party.get(i);
            }
            if (data == null) {
                DeleteTrainerPokemonPacket.deletePokemon(this.trainerID, numPokemon, context, i == 5);
                continue;
            }
            handler.handle(context);
        }
    }
}

