/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.api.pokemon.stats.BaseStatsLearnType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import com.pixelmonmod.pixelmon.items.NPCEditorItem;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class StoreTutorDataPacket
extends AbstractPixelmonPacket {
    int npcId;
    List<NPCTutor.LearnableMove> learnableMoves;
    EnumSet<BaseStatsLearnType> learnTypes = EnumSet.noneOf(BaseStatsLearnType.class);

    public StoreTutorDataPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public StoreTutorDataPacket(int npcId, List<NPCTutor.LearnableMove> learnableMoves, EnumSet<BaseStatsLearnType> learnTypes) {
        super(PacketDirection.PLAY_SERVER);
        this.npcId = npcId;
        this.learnableMoves = learnableMoves;
        this.learnTypes = learnTypes;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        int i;
        this.npcId = buf.readInt();
        int count = buf.readInt();
        this.learnableMoves = new ArrayList<NPCTutor.LearnableMove>(count);
        for (i = 0; i < count; ++i) {
            NPCTutor.LearnableMove move = new NPCTutor.LearnableMove();
            move.decode(buf);
            this.learnableMoves.add(move);
        }
        count = buf.readInt();
        this.learnTypes.clear();
        for (i = 0; i < count; ++i) {
            BaseStatsLearnType type = BaseStatsLearnType.fromOrdinal(buf.readByte());
            if (type == null) continue;
            this.learnTypes.add(type);
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.npcId);
        buf.writeInt(this.learnableMoves.size());
        for (NPCTutor.LearnableMove learnableMove : this.learnableMoves) {
            learnableMove.encode(buf);
        }
        buf.writeInt(this.learnTypes.size());
        for (BaseStatsLearnType type : this.learnTypes) {
            buf.writeByte(type.ordinal());
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player == null || !NPCEditorItem.checkPermission((Player)player)) {
            return;
        }
        Optional<NPCTutor> optional = NPCEntity.locateNPCServer(player.m_9236_(), this.npcId, NPCTutor.class);
        if (optional.isPresent()) {
            NPCTutor tutor = optional.get();
            tutor.moveList.clear();
            tutor.moveList.addAll(this.learnableMoves);
            tutor.learnTypes.clear();
            tutor.learnTypes.addAll(this.learnTypes);
        }
    }
}

