/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.comm.SetTrainerData;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.EnumStoreTrainerDataType;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.items.NPCEditorItem;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class StoreTrainerDataPacket
extends AbstractPixelmonPacket {
    private int trainerId;
    private SetTrainerData data;
    private ItemStack[] drops;
    private EnumStoreTrainerDataType dataType;

    public StoreTrainerDataPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public StoreTrainerDataPacket(int trainerId, SetTrainerData data) {
        super(PacketDirection.PLAY_SERVER);
        this.trainerId = trainerId;
        this.data = data;
        this.dataType = EnumStoreTrainerDataType.CHAT;
    }

    public StoreTrainerDataPacket(int currentTrainerID, ItemStack ... drops) {
        super(PacketDirection.PLAY_SERVER);
        this.trainerId = currentTrainerID;
        this.drops = drops;
        this.dataType = EnumStoreTrainerDataType.DROPS;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.trainerId = buf.readInt();
        this.dataType = EnumStoreTrainerDataType.values()[buf.readInt()];
        if (this.dataType == EnumStoreTrainerDataType.CHAT) {
            this.data = new SetTrainerData();
            this.data.decodeInto(buf);
        } else {
            this.drops = new ItemStack[buf.readInt()];
            for (int i = 0; i < this.drops.length; ++i) {
                this.drops[i] = buf.m_130267_();
            }
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.trainerId);
        buf.writeInt(this.dataType.ordinal());
        if (this.dataType == EnumStoreTrainerDataType.CHAT) {
            this.data.encodeInto(buf);
        } else {
            buf.writeInt(this.drops.length);
            for (ItemStack stack : this.drops) {
                buf.m_130055_(stack);
            }
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (!NPCEditorItem.checkPermission((Player)player)) {
            return;
        }
        Optional<NPCTrainer> entityNPCOptional = NPCEntity.locateNPCServer(player.m_9236_(), this.trainerId, NPCTrainer.class);
        if (!entityNPCOptional.isPresent()) {
            return;
        }
        NPCTrainer trainer = entityNPCOptional.get();
        if (this.dataType == EnumStoreTrainerDataType.CHAT) {
            trainer.update(this.data);
        } else {
            trainer.updateDrops(this.drops);
        }
    }
}

