/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.economy.BankAccount;
import com.pixelmonmod.pixelmon.api.economy.BankAccountProxy;
import com.pixelmonmod.pixelmon.api.events.ShopkeeperEvent;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCShopkeeper;
import com.pixelmonmod.pixelmon.entities.npcs.registry.EnumBuySell;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopItemWithVariation;
import com.pixelmonmod.pixelmon.items.PokeBallItem;
import com.pixelmonmod.pixelmon.items.PokeBallPart;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ShopKeeperPacket
extends AbstractPixelmonPacket {
    private EnumBuySell buySell;
    private String itemID;
    private int amount;
    private int shopKeeperID;

    public ShopKeeperPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public ShopKeeperPacket(EnumBuySell buySell, int shopkeeperID, String itemID, int amount) {
        super(PacketDirection.PLAY_SERVER, true);
        this.shopKeeperID = shopkeeperID;
        this.itemID = itemID;
        this.amount = amount;
        this.buySell = buySell;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.buySell = buf.readBoolean() ? EnumBuySell.Buy : EnumBuySell.Sell;
        this.shopKeeperID = buf.readInt();
        this.itemID = buf.m_130277_();
        this.amount = buf.readInt();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.buySell == EnumBuySell.Buy);
        buf.writeInt(this.shopKeeperID);
        buf.m_130070_(this.itemID);
        buf.writeInt(this.amount);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer p = context.getSender();
        Optional<NPCShopkeeper> npcOptional = NPCEntity.locateNPCServer(p.m_9236_(), this.shopKeeperID, NPCShopkeeper.class);
        BankAccount account = BankAccountProxy.getBankAccountNow(p);
        if (!npcOptional.isPresent() || this.amount <= 0 || account == null) {
            return;
        }
        NPCShopkeeper npc = npcOptional.get();
        if (this.buySell == EnumBuySell.Buy) {
            ArrayList<ShopItemWithVariation> itemList = npc.getItemList();
            for (ShopItemWithVariation shopItem : itemList) {
                if (!shopItem.getBaseShopItem().id.equals(this.itemID)) continue;
                if (this.amount > PixelmonConfigProxy.getGeneral().getShopMaxStackSize(shopItem.getItemStack())) {
                    return;
                }
                if (!(account.getBalance().doubleValue() >= (double)(shopItem.getBuyCost() * this.amount))) continue;
                if (shopItem.getBuyCost() * this.amount < 0) {
                    return;
                }
                BigInteger total = BigInteger.valueOf(this.amount).multiply(BigInteger.valueOf(shopItem.getBuyCost()));
                if (total.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) >= 0) {
                    Pixelmon.LOGGER.error("Integer overflow whilst purchasing item from " + npc.m_7755_() + " player: " + p.m_7755_());
                    return;
                }
                ItemStack item = shopItem.getItemStack();
                ItemStack buyStack = item.m_41777_();
                int initialAmount = this.amount;
                buyStack.m_41764_(this.amount);
                if (Pixelmon.EVENT_BUS.post((Event)new ShopkeeperEvent.Purchase(p, npc, buyStack, EnumBuySell.Buy))) {
                    return;
                }
                if (p.m_36356_(buyStack)) {
                    Item buyItem = item.m_41720_();
                    PokeBall pokeBall = PokeBallPart.getPokeBall(buyStack).orElse(null);
                    if (buyItem instanceof PokeBallItem && PokeBallRegistry.POKE_BALL.getValueUnsafe().is(pokeBall) && this.amount >= 10) {
                        ItemStack premierBall = PokeBallRegistry.PREMIER_BALL.getValueUnsafe().getBallItem();
                        p.m_36356_(premierBall);
                    }
                    if (buyItem == Items.f_41852_) continue;
                    account.take(shopItem.getBuyCost() * this.amount);
                    this.updateTransaction(p, npc);
                    continue;
                }
                if (initialAmount <= buyStack.m_41613_()) continue;
                int actualAmount = initialAmount - buyStack.m_41613_();
                account.take(shopItem.getBuyCost() * actualAmount);
                this.updateTransaction(p, npc);
            }
        } else {
            ArrayList<ShopItemWithVariation> sellList = npc.getSellList((Player)p);
            for (ShopItemWithVariation shopItem : sellList) {
                if (!shopItem.getBaseShopItem().id.equals(this.itemID)) continue;
                int count = 0;
                ItemStack sStack = shopItem.getItemStack();
                for (int i = 0; i < p.m_150109_().f_35974_.size(); ++i) {
                    ItemStack item = (ItemStack)p.m_150109_().f_35974_.get(i);
                    if (!this.areItemsEqual(item, sStack)) continue;
                    count += item.m_41613_();
                }
                ItemStack copy = sStack.m_41777_();
                copy.m_41764_(this.amount);
                if (Pixelmon.EVENT_BUS.post((Event)new ShopkeeperEvent.Sell(p, npc, EnumBuySell.Sell, copy))) {
                    return;
                }
                if (count < this.amount) continue;
                int cost = shopItem.getSellCost();
                count = this.amount;
                BigInteger total = BigInteger.valueOf(this.amount).multiply(BigInteger.valueOf(shopItem.getSellCost()));
                if (total.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) >= 0) {
                    Pixelmon.LOGGER.error("Integer overflow whilst selling item to " + npc.m_7755_() + " player: " + p.m_7755_());
                    return;
                }
                for (int i = 0; i < p.m_150109_().f_35974_.size(); ++i) {
                    ItemStack item = (ItemStack)p.m_150109_().f_35974_.get(i);
                    if (this.areItemsEqual(item, sStack)) {
                        if (item.m_41613_() >= count) {
                            item.m_41764_(item.m_41613_() - count);
                            count = 0;
                        } else {
                            count -= item.m_41613_();
                            item.m_41764_(0);
                        }
                        if (item.m_41613_() == 0) {
                            p.m_150109_().f_35974_.set(i, (Object)ItemStack.f_41583_);
                        }
                    }
                    if (count <= 0) break;
                }
                account.add(cost * this.amount);
                this.updateTransaction(p, npc);
            }
        }
    }

    private void updateTransaction(ServerPlayer p, NPCShopkeeper npc) {
        p.f_36095_.m_38946_();
        npc.sendItemsToPlayer((Player)p);
    }

    private boolean areItemsEqual(ItemStack item1, ItemStack item2) {
        return !item1.m_41619_() && ItemStack.m_41656_((ItemStack)item1, (ItemStack)item2) && ItemStack.m_150942_((ItemStack)item1, (ItemStack)item2) && item1.m_41773_() == item2.m_41773_();
    }
}

