/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class SelectPokemonResponsePacket
extends AbstractPixelmonPacket {
    Mode mode;
    int npcId;
    UUID pokemon;

    public SelectPokemonResponsePacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public SelectPokemonResponsePacket(Mode mode, int npcId, UUID pokemon) {
        super(PacketDirection.PLAY_SERVER, true);
        this.mode = mode;
        this.npcId = npcId;
        this.pokemon = pokemon;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.mode = Mode.fromOrdinal(buf.readByte());
        this.npcId = buf.readInt();
        this.pokemon = buf.m_130259_();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeByte(this.mode.ordinal());
        buf.writeInt(this.npcId);
        buf.m_130077_(this.pokemon);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player == null) {
            return;
        }
        PlayerPartyStorage storage = StorageProxy.getPartyNow(player);
        Pokemon pokemon = storage.find(this.pokemon);
        if (pokemon == null) {
            return;
        }
        if (this.mode == Mode.Tutor || this.mode == Mode.Transfer_Tutor) {
            if (pokemon.isEgg()) {
                return;
            }
            Optional<NPCTutor> tutor = NPCEntity.locateNPCServer(player.m_9236_(), this.npcId, NPCTutor.class);
            tutor.ifPresent(it -> it.handlePickedPokemon(player, pokemon));
        }
    }

    public static enum Mode {
        Tutor,
        Transfer_Tutor,
        Relearner,
        Revive,
        Custom;

        private static final Mode[] VALUES;

        public static Mode fromOrdinal(int index) {
            return VALUES[index];
        }

        static {
            VALUES = Mode.values();
        }
    }
}

