/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.items.NPCEditorItem;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class RandomiseTrainerPokemonPacket
extends AbstractPixelmonPacket {
    private int trainerId;

    public RandomiseTrainerPokemonPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public RandomiseTrainerPokemonPacket(int trainerId) {
        super(PacketDirection.PLAY_SERVER);
        this.trainerId = trainerId;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.trainerId);
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.trainerId = buffer.readInt();
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (!NPCEditorItem.checkPermission((Player)player)) {
            return;
        }
        Optional<NPCTrainer> trainer = NPCEntity.locateNPCServer(player.m_9236_(), this.trainerId, NPCTrainer.class);
        trainer.ifPresent(npcTrainer -> npcTrainer.randomisePokemon((Player)player));
    }
}

