/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.battles.BattleAIMode;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTier;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTierRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.TrainerPartyStorage;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ClearTrainerPokemonPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.EnumNPCServerPacketType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.StoreTrainerPokemonPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.ChangePokemonOpenGUIPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCChatting;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCShopkeeper;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrader;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ClientNPCData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.enums.EnumEncounterMode;
import com.pixelmonmod.pixelmon.enums.EnumMegaItemsUnlocked;
import com.pixelmonmod.pixelmon.enums.EnumOldGenMode;
import com.pixelmonmod.pixelmon.enums.EnumTrainerAI;
import com.pixelmonmod.pixelmon.items.NPCEditorItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class NPCServerPacket
extends AbstractPixelmonPacket {
    private EnumNPCServerPacketType mode;
    private int npcID;
    private EnumTrainerAI ai;
    private BattleAIMode battleAI;
    private BossTier bm;
    private EnumEncounterMode em;
    private BattleRules battleRules;
    private int modelIndex;
    private String data;
    private Species pokemon;
    private int pos;
    private int integer;
    private ArrayList<String> pages;
    private PokemonSpecification exchange;
    private PokemonSpecification offer;
    private String description;
    private ClientNPCData npcData;
    private String shopkeeperType;
    private int engageDistance;
    private EnumMegaItemsUnlocked mi;
    private EnumOldGenMode og;

    public NPCServerPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public NPCServerPacket(int npcID) {
        super(PacketDirection.PLAY_SERVER, true);
        this.npcID = npcID;
    }

    public NPCServerPacket(int npcID, EnumTrainerAI ai) {
        this(npcID);
        this.mode = EnumNPCServerPacketType.AI;
        this.ai = ai;
    }

    public NPCServerPacket(int npcID, BattleAIMode battleAI) {
        this(npcID);
        this.mode = EnumNPCServerPacketType.BattleAI;
        this.battleAI = battleAI;
    }

    public NPCServerPacket(int npcID, BossTier bm) {
        this(npcID);
        this.mode = EnumNPCServerPacketType.BossMode;
        this.bm = bm;
    }

    public NPCServerPacket(int npcID, EnumEncounterMode bm) {
        this(npcID);
        this.mode = EnumNPCServerPacketType.EncounterMode;
        this.em = bm;
    }

    public NPCServerPacket(int npcID, EnumMegaItemsUnlocked mi) {
        this(npcID);
        this.mode = EnumNPCServerPacketType.MegaItem;
        this.mi = mi;
    }

    public NPCServerPacket(int npcID, EnumOldGenMode og) {
        this(npcID);
        this.mode = EnumNPCServerPacketType.OldGen;
        this.og = og;
    }

    public NPCServerPacket(int npcID, BattleRules battleRules) {
        this(npcID);
        this.mode = EnumNPCServerPacketType.BattleRules;
        this.battleRules = battleRules;
    }

    public NPCServerPacket(int npcID, int modelIndex) {
        this(npcID);
        this.mode = EnumNPCServerPacketType.Model;
        this.modelIndex = modelIndex;
    }

    public NPCServerPacket(int npcID, EnumNPCServerPacketType mode, String data) {
        this(npcID);
        this.mode = mode;
        this.data = data;
    }

    public NPCServerPacket(int npcID, Species pokemon, int pos) {
        this(npcID);
        this.mode = EnumNPCServerPacketType.Pokemon;
        this.pokemon = pokemon;
        this.pos = pos;
    }

    public NPCServerPacket(int npcID, EnumNPCServerPacketType mode, int textureIndex) {
        this(npcID);
        this.mode = mode;
        this.integer = textureIndex;
    }

    public NPCServerPacket(int npcID, EnumNPCServerPacketType mode) {
        this(npcID);
        this.mode = mode;
    }

    public NPCServerPacket(int npcID, ClientNPCData npcData) {
        this(npcID);
        this.mode = EnumNPCServerPacketType.CycleTexture;
        this.npcData = npcData;
    }

    public NPCServerPacket(int npcID, ArrayList<String> pages) {
        this(npcID);
        this.mode = EnumNPCServerPacketType.ChatPages;
        this.pages = pages;
    }

    public NPCServerPacket(int npcID, PokemonSpecification offer, PokemonSpecification exchange, String description) {
        this(npcID);
        this.mode = EnumNPCServerPacketType.Trader;
        this.offer = offer;
        this.exchange = exchange;
        this.description = description;
    }

    public NPCServerPacket(int npcID, int engageDistance, EnumNPCServerPacketType type) {
        this(npcID);
        this.mode = type;
        this.engageDistance = engageDistance;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeShort(this.mode.ordinal());
        buffer.writeInt(this.npcID);
        switch (this.mode) {
            case AI: {
                buffer.writeInt(this.ai.ordinal());
                break;
            }
            case BattleAI: {
                buffer.writeInt(this.battleAI.ordinal());
                break;
            }
            case BossMode: {
                buffer.m_130070_(this.bm.getID());
                break;
            }
            case EncounterMode: {
                buffer.writeInt(this.em.ordinal());
                break;
            }
            case OldGen: {
                buffer.writeInt(this.og.ordinal());
                break;
            }
            case MegaItem: {
                buffer.writeInt(this.mi.ordinal());
                break;
            }
            case BattleRules: {
                this.battleRules.encodeInto(buffer);
                break;
            }
            case Model: {
                buffer.writeInt(this.modelIndex);
                break;
            }
            case CustomSteveTexture: 
            case Name: 
            case CycleJson: {
                buffer.m_130070_(this.data);
                break;
            }
            case Pokemon: {
                buffer.writeInt(this.pokemon.getDex());
                buffer.writeInt(this.pos);
                break;
            }
            case TextureIndex: 
            case CycleName: {
                buffer.writeInt(this.integer);
                break;
            }
            case ChatPages: {
                buffer.writeInt(this.pages.size());
                for (String page : this.pages) {
                    buffer.m_130070_(page);
                }
                break;
            }
            case Trader: {
                buffer.m_130079_((Tag)this.offer.write(new CompoundTag()));
                buffer.m_130079_((Tag)this.exchange.write(new CompoundTag()));
                if (this.description == null) {
                    this.description = "null";
                }
                buffer.m_130070_(this.description);
                break;
            }
            case CycleTexture: {
                if (this.npcData == null) {
                    this.npcData = new ClientNPCData("");
                }
                this.npcData.encodeInto(buffer);
                break;
            }
            case EngageDistance: {
                buffer.writeInt(this.engageDistance);
                break;
            }
        }
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.mode = EnumNPCServerPacketType.values()[buffer.readShort()];
        this.npcID = buffer.readInt();
        switch (this.mode) {
            case AI: {
                this.ai = EnumTrainerAI.getFromOrdinal(buffer.readInt());
                break;
            }
            case BattleAI: {
                this.battleAI = BattleAIMode.getFromIndex(buffer.readInt());
                break;
            }
            case BossMode: {
                this.bm = BossTierRegistry.getBossTierOrNotBoss(buffer.m_130277_());
                break;
            }
            case EncounterMode: {
                this.em = EnumEncounterMode.getFromIndex(buffer.readInt());
                break;
            }
            case OldGen: {
                this.og = EnumOldGenMode.getFromIndex(buffer.readInt());
                break;
            }
            case MegaItem: {
                this.mi = EnumMegaItemsUnlocked.values()[buffer.readInt()];
                break;
            }
            case BattleRules: {
                this.battleRules = new BattleRules();
                this.battleRules.decodeInto(buffer);
                break;
            }
            case Model: {
                this.modelIndex = buffer.readInt();
                break;
            }
            case CustomSteveTexture: 
            case Name: 
            case CycleJson: {
                this.data = buffer.m_130277_();
                break;
            }
            case Pokemon: {
                this.pokemon = PixelmonSpecies.fromNationalDex(buffer.readInt());
                this.pos = buffer.readInt();
                break;
            }
            case TextureIndex: 
            case CycleName: {
                this.integer = buffer.readInt();
                break;
            }
            case ChatPages: {
                int numPages = buffer.readInt();
                this.pages = new ArrayList();
                for (int i = 0; i < numPages; ++i) {
                    this.pages.add(buffer.m_130277_());
                }
                break;
            }
            case Trader: {
                this.offer = PokemonSpecificationProxy.fromNbt(buffer.m_130260_()).get();
                this.exchange = PokemonSpecificationProxy.fromNbt(buffer.m_130260_()).get();
                this.description = buffer.m_130277_();
                if (!this.description.equals("null")) break;
                this.description = null;
                break;
            }
            case CycleTexture: {
                this.npcData = new ClientNPCData(buffer);
                break;
            }
            case EngageDistance: {
                this.engageDistance = buffer.readInt();
                break;
            }
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer p = context.getSender();
        if (!NPCEditorItem.checkPermission((Player)p)) {
            return;
        }
        NPCTrader trader = null;
        Optional<NPCEntity> npcOptional = NPCEntity.locateNPCServer(p.m_9236_(), this.npcID, NPCEntity.class);
        if (!npcOptional.isPresent()) {
            return;
        }
        NPCEntity npc = npcOptional.get();
        NPCTrainer trainer = null;
        if (npc instanceof NPCTrainer) {
            trainer = (NPCTrainer)npc;
        } else if (npc instanceof NPCTrader) {
            trader = (NPCTrader)npc;
        }
        switch (this.mode) {
            case AI: {
                trainer.setAIMode(this.ai);
                break;
            }
            case BattleAI: {
                trainer.setBattleAIMode(this.battleAI);
                break;
            }
            case BossMode: {
                trainer.setBossTier(this.bm);
                break;
            }
            case EncounterMode: {
                trainer.setEncounterMode(this.em);
                break;
            }
            case MegaItem: {
                trainer.setMegaItem(this.mi);
                break;
            }
            case OldGen: {
                trainer.setOldGenMode(this.og);
                break;
            }
            case BattleRules: {
                trainer.battleRules = this.battleRules;
                break;
            }
            case Model: {
                if (npc instanceof NPCTrainer) {
                    ((NPCTrainer)npc).setTrainerType(ServerNPCRegistry.trainers.getById(this.modelIndex), (Player)p);
                    break;
                }
                npc.setBaseTrainer(ServerNPCRegistry.trainers.getById(this.modelIndex));
                break;
            }
            case Name: {
                if (this.data != null) {
                    npc.setName(this.data);
                }
                if (trainer == null) break;
                trainer.initAI();
                break;
            }
            case Pokemon: {
                Pokemon pokemon = PokemonFactory.create(this.pokemon);
                TrainerPartyStorage storage = trainer.getPokemonStorage();
                storage.set(this.pos, null);
                storage.add(pokemon);
                trainer.updateTrainerLevel();
                List<Pokemon> storageList = storage.getTeam();
                this.reply(context, new ClearTrainerPokemonPacket());
                for (int i = 0; i < storageList.size(); ++i) {
                    this.reply(context, new StoreTrainerPokemonPacket(storageList.get(i)));
                }
                this.reply(context, new ChangePokemonOpenGUIPacket(this.pos));
                break;
            }
            case TextureIndex: {
                npc.setTextureIndex(this.integer);
                break;
            }
            case CustomSteveTexture: {
                npc.setCustomSteveTexture(this.data);
                break;
            }
            case ChatPages: {
                if (!(npc instanceof NPCChatting)) break;
                ((NPCChatting)npc).setChat(this.pages);
                break;
            }
            case Trader: {
                if (trader == null) break;
                trader.updateTrade(this.offer, this.exchange, this.description);
                break;
            }
            case CycleTexture: {
                if (!(npc instanceof NPCChatting)) break;
                ((NPCChatting)npc).cycleTexture(p, this.npcData);
                break;
            }
            case CycleJson: {
                if (!(npc instanceof NPCShopkeeper)) break;
                ((NPCShopkeeper)npc).cycleJson(p, this.data);
                break;
            }
            case CycleName: {
                if (!(npc instanceof NPCShopkeeper)) break;
                ((NPCShopkeeper)npc).cycleName(p, this.integer);
                break;
            }
            case RefreshItems: {
                if (!(npc instanceof NPCShopkeeper)) break;
                ((NPCShopkeeper)npc).loadItems();
                break;
            }
            case EngageDistance: {
                if (npc instanceof NPCTrainer) {
                    ((NPCTrainer)npc).setEngageDistance(this.engageDistance);
                }
                npc.initAI();
            }
        }
    }
}

