/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class NPCLearnMovePacket
extends AbstractPixelmonPacket {
    private UUID pokemonUUID;
    private EnumNPCType npcType;

    public NPCLearnMovePacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public NPCLearnMovePacket(UUID pokemonUUID, EnumNPCType npcType) {
        super(PacketDirection.PLAY_SERVER, true);
        this.pokemonUUID = pokemonUUID;
        this.npcType = npcType;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.pokemonUUID = buf.m_130259_();
        this.npcType = EnumNPCType.getFromOrdinal(buf.readInt());
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.pokemonUUID);
        buf.writeInt(this.npcType.ordinal());
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        PlayerPartyStorage party = StorageProxy.getPartyNow(player);
        Pokemon pokemon = party.find(this.pokemonUUID);
        if (pokemon == null) {
            return;
        }
        if (this.npcType == EnumNPCType.Relearner) {
            OpenScreenPacket.open((Player)player, EnumGuiScreen.Relearner, pokemon.getPosition().order);
        } else if (this.npcType == EnumNPCType.Tutor) {
            OpenScreenPacket.open((Player)player, EnumGuiScreen.Tutor, pokemon.getPosition().order);
        }
    }
}

