/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.api.pokemon.stats.BaseStatsLearnType;
import com.pixelmonmod.pixelmon.client.gui.npc.TutorScreen;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.TutorEditorScreen;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class LoadTutorDataPacket
extends AbstractPixelmonPacket {
    List<NPCTutor.LearnableMove> learnableMoves;
    EnumSet<BaseStatsLearnType> learnTypes = EnumSet.noneOf(BaseStatsLearnType.class);

    public LoadTutorDataPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public LoadTutorDataPacket(List<NPCTutor.LearnableMove> learnableMoves) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.learnableMoves = learnableMoves;
    }

    public LoadTutorDataPacket(List<NPCTutor.LearnableMove> learnableMoves, EnumSet<BaseStatsLearnType> learnTypes) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.learnableMoves = learnableMoves;
        this.learnTypes = learnTypes;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        int i;
        int count = buf.readInt();
        this.learnableMoves = new ArrayList<NPCTutor.LearnableMove>();
        for (i = 0; i < count; ++i) {
            NPCTutor.LearnableMove move = new NPCTutor.LearnableMove();
            move.decode(buf);
            this.learnableMoves.add(move);
        }
        count = buf.readInt();
        this.learnTypes.clear();
        for (i = 0; i < count; ++i) {
            BaseStatsLearnType type = BaseStatsLearnType.fromOrdinal(buf.readByte());
            if (type == null) continue;
            this.learnTypes.add(type);
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.learnableMoves.size());
        for (NPCTutor.LearnableMove learnableMove : this.learnableMoves) {
            learnableMove.encode(buf);
        }
        buf.writeInt(this.learnTypes.size());
        for (BaseStatsLearnType type : this.learnTypes) {
            buf.writeByte(type.ordinal());
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        TutorScreen.moveList = this.learnableMoves;
        TutorEditorScreen.learnTypes = this.learnTypes;
    }
}

