/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.TrainerPartyStorage;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.items.NPCEditorItem;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class DeleteTrainerPokemonPacket
extends AbstractPixelmonPacket {
    private int trainerID;
    private int position;

    public DeleteTrainerPokemonPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public DeleteTrainerPokemonPacket(int trainerID, int position) {
        super(PacketDirection.PLAY_SERVER);
        this.trainerID = trainerID;
        this.position = position;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.trainerID);
        buffer.writeInt(this.position);
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.trainerID = buffer.readInt();
        this.position = buffer.readInt();
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        if (!NPCEditorItem.checkPermission((Player)context.getSender())) {
            return;
        }
        DeleteTrainerPokemonPacket.deletePokemon(this.trainerID, this.position, context, true);
    }

    public static void deletePokemon(int trainerID, int position, CustomPayloadEvent.Context context, boolean updateClient) {
        ServerPlayer player = context.getSender();
        Optional<NPCTrainer> entityNPCOptional = NPCEntity.locateNPCServer(player.m_9236_(), trainerID, NPCTrainer.class);
        if (!entityNPCOptional.isPresent()) {
            return;
        }
        NPCTrainer t = entityNPCOptional.get();
        TrainerPartyStorage storage = t.getPokemonStorage();
        if (storage.getTeam().size() <= position) {
            return;
        }
        Pokemon pokemon = storage.getTeam().get(position);
        if (storage.countAll() > 1) {
            storage.set(pokemon.getPosition().order, null);
        }
        t.updateTrainerLevel();
        if (updateClient) {
            storage.sendCacheToPlayer(player);
        }
    }
}

