/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.items.NPCEditorItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class DeleteNPCPacket
extends AbstractPixelmonPacket {
    private int entityId;

    public DeleteNPCPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public DeleteNPCPacket(int entityId) {
        super(PacketDirection.PLAY_SERVER, true);
        this.entityId = entityId;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (!NPCEditorItem.checkPermission((Player)player)) {
            return;
        }
        Entity entity = player.m_9236_().m_6815_(this.entityId);
        if (entity instanceof NPCEntity) {
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }
}

