/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.comm.SetTrainerData;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ClearTrainerPokemonPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetNPCEditDataPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.StoreTrainerPokemonPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCChatting;
import com.pixelmonmod.pixelmon.entities.npcs.NPCFisherman;
import com.pixelmonmod.pixelmon.entities.npcs.NPCNurseJoy;
import com.pixelmonmod.pixelmon.entities.npcs.NPCQuestGiver;
import com.pixelmonmod.pixelmon.entities.npcs.NPCRelearner;
import com.pixelmonmod.pixelmon.entities.npcs.NPCShopkeeper;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrader;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import com.pixelmonmod.pixelmon.entities.npcs.registry.GeneralNPCData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.NPCRegistryTrainers;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopkeeperData;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumNPCTutorType;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import com.pixelmonmod.pixelmon.enums.EnumTrainerAI;
import com.pixelmonmod.pixelmon.items.NPCEditorItem;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class CreateNPCPacket
extends AbstractPixelmonPacket {
    private EnumNPCType type;
    private BlockPos pos;
    private float rotation;

    public CreateNPCPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public CreateNPCPacket(EnumNPCType type, BlockPos pos, float rotation) {
        super(PacketDirection.PLAY_SERVER, true);
        this.type = type;
        this.pos = pos;
        this.rotation = rotation;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.type = EnumNPCType.getFromOrdinal(buf.readByte());
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.rotation = buf.readFloat();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeByte(this.type.ordinal());
        buf.writeInt(this.pos.m_123341_());
        buf.writeInt(this.pos.m_123342_());
        buf.writeInt(this.pos.m_123343_());
        buf.writeFloat(this.rotation);
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (!NPCEditorItem.checkPermission((Player)player)) {
            return;
        }
        BlockPos blockPos = this.pos;
        float rotationYaw = this.rotation;
        switch (this.type) {
            case Trainer: {
                NPCTrainer trainer = new NPCTrainer(player.m_9236_());
                trainer.init(NPCRegistryTrainers.Steve);
                trainer.m_6034_((float)blockPos.m_123341_() + 0.5f, blockPos.m_123342_() + 1, (float)blockPos.m_123343_() + 0.5f);
                trainer.setAIMode(EnumTrainerAI.StandStill);
                trainer.initAI();
                player.m_9236_().m_7967_((Entity)trainer);
                trainer.m_6034_((float)blockPos.m_123341_() + 0.5f, blockPos.m_123342_() + 1, (float)blockPos.m_123343_() + 0.5f);
                trainer.setStartRotationYaw(rotationYaw + 180.0f);
                trainer.m_21530_();
                this.reply(context, new ClearTrainerPokemonPacket());
                for (int i = 0; i < trainer.getPokemonStorage().countAll(); ++i) {
                    this.reply(context, new StoreTrainerPokemonPacket(trainer.getPokemonStorage().get(i)));
                }
                SetTrainerData trainerData = new SetTrainerData(trainer, player.getLanguage());
                this.reply(context, new SetNPCEditDataPacket(trainerData));
                OpenScreenPacket.open((Player)player, EnumGuiScreen.TrainerEditor, trainer.getNPCID());
                break;
            }
            case Trader: {
                NPCTrader trader = new NPCTrader(player.m_9236_());
                trader.m_6034_((float)blockPos.m_123341_() + 0.5f, blockPos.m_123342_() + 1, (float)blockPos.m_123343_() + 0.5f);
                player.m_9236_().m_7967_((Entity)trader);
                trader.m_21530_();
                break;
            }
            case ChattingNPC: {
                NPCChatting npc = new NPCChatting(player.m_9236_());
                GeneralNPCData data = ServerNPCRegistry.villagers.getRandom();
                npc.init(data);
                npc.initDefaultAI();
                npc.setCustomSteveTexture(data.getRandomTexture());
                npc.m_6034_((float)blockPos.m_123341_() + 0.5f, blockPos.m_123342_() + 1, (float)blockPos.m_123343_() + 0.5f);
                npc.m_21530_();
                player.m_9236_().m_7967_((Entity)npc);
                break;
            }
            case QuestGiver: {
                NPCQuestGiver questGiver = new NPCQuestGiver(player.m_9236_());
                GeneralNPCData data2 = ServerNPCRegistry.villagers.getRandom();
                questGiver.init(data2);
                questGiver.initDefaultAI();
                questGiver.m_6034_((float)blockPos.m_123341_() + 0.5f, blockPos.m_123342_() + 1, (float)blockPos.m_123343_() + 0.5f);
                questGiver.m_21530_();
                player.m_9236_().m_7967_((Entity)questGiver);
                questGiver.setCustomSteveTexture(data2.getRandomTexture());
                break;
            }
            case Relearner: {
                NPCRelearner relearner = new NPCRelearner(player.m_9236_());
                relearner.m_6034_((float)blockPos.m_123341_() + 0.5f, blockPos.m_123342_() + 1, (float)blockPos.m_123343_() + 0.5f);
                relearner.setAIMode(EnumTrainerAI.StandStill);
                relearner.initAI();
                relearner.m_21530_();
                player.m_9236_().m_7967_((Entity)relearner);
                break;
            }
            case Tutor: {
                NPCTutor tutor = new NPCTutor(player.m_9236_());
                tutor.init("Tutor");
                tutor.m_6034_((float)blockPos.m_123341_() + 0.5f, blockPos.m_123342_() + 1, (float)blockPos.m_123343_() + 0.5f);
                tutor.setAIMode(EnumTrainerAI.StandStill);
                tutor.initAI();
                tutor.m_21530_();
                player.m_9236_().m_7967_((Entity)tutor);
                break;
            }
            case TransferTutor: {
                NPCTutor transfer = new NPCTutor(player.m_9236_());
                transfer.init("Tutor");
                transfer.setTutorType(EnumNPCTutorType.TRANSFER);
                transfer.m_6034_((float)blockPos.m_123341_() + 0.5f, blockPos.m_123342_() + 1, (float)blockPos.m_123343_() + 0.5f);
                transfer.setAIMode(EnumTrainerAI.StandStill);
                transfer.initAI();
                transfer.m_21530_();
                player.m_9236_().m_7967_((Entity)transfer);
                break;
            }
            case Shopkeeper: {
                ShopkeeperData shopData = ServerNPCRegistry.shopkeepers.getRandom();
                if (shopData == null) {
                    return;
                }
                NPCShopkeeper shopkeeper = new NPCShopkeeper(player.m_9236_());
                shopkeeper.init(shopData);
                shopkeeper.initDefaultAI();
                shopkeeper.m_6034_((float)blockPos.m_123341_() + 0.5f, blockPos.m_123342_() + 1, (float)blockPos.m_123343_() + 0.5f);
                shopkeeper.m_21530_();
                player.m_9236_().m_7967_((Entity)shopkeeper);
                break;
            }
            case NurseJoy: {
                NPCNurseJoy nursejoy = new NPCNurseJoy(player.m_9236_(), 1);
                nursejoy.m_6034_((float)blockPos.m_123341_() + 0.5f, blockPos.m_123342_() + 1, (float)blockPos.m_123343_() + 0.5f);
                nursejoy.initDefaultAI();
                nursejoy.m_21530_();
                player.m_9236_().m_7967_((Entity)nursejoy);
                break;
            }
            case Doctor: {
                NPCNurseJoy doctor = new NPCNurseJoy(player.m_9236_(), 0);
                doctor.m_6034_((float)blockPos.m_123341_() + 0.5f, blockPos.m_123342_() + 1, (float)blockPos.m_123343_() + 0.5f);
                doctor.initDefaultAI();
                doctor.m_21530_();
                player.m_9236_().m_7967_((Entity)doctor);
                break;
            }
            case OldFisherman: {
                NPCFisherman fisherman = new NPCFisherman(player.m_9236_());
                fisherman.m_6034_((float)blockPos.m_123341_() + 0.5f, blockPos.m_123342_() + 1, (float)blockPos.m_123343_() + 0.5f);
                fisherman.initDefaultAI();
                fisherman.m_21530_();
                player.m_9236_().m_7967_((Entity)fisherman);
                break;
            }
            case TCGTrader: {
                NPCChatting tcgTrader = new NPCChatting(player.m_9236_());
                GeneralNPCData tcgTraderData = ServerNPCRegistry.villagers.getRandom();
                tcgTrader.init(tcgTraderData);
                tcgTrader.initDefaultAI();
                tcgTrader.setCustomSteveTexture(tcgTraderData.getRandomTexture());
                tcgTrader.m_6034_((float)blockPos.m_123341_() + 0.5f, blockPos.m_123342_() + 1, (float)blockPos.m_123343_() + 0.5f);
                tcgTrader.m_21530_();
                tcgTrader.getPersistentData().m_128379_("TCGTrader", true);
                player.m_9236_().m_7967_((Entity)tcgTrader);
            }
        }
    }
}

