/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.TrainerPartyStorage;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.ChangePokemonOpenGUIPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.items.NPCEditorItem;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class AddTrainerPokemonPacket
extends AbstractPixelmonPacket {
    private int trainerID;

    public AddTrainerPokemonPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public AddTrainerPokemonPacket(int trainerId) {
        super(PacketDirection.PLAY_SERVER);
        this.trainerID = trainerId;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.trainerID);
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.trainerID = buffer.readInt();
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (!NPCEditorItem.checkPermission((Player)player)) {
            return;
        }
        Optional<NPCTrainer> entityNPCOptional = NPCEntity.locateNPCServer(player.m_9236_(), this.trainerID, NPCTrainer.class);
        if (!entityNPCOptional.isPresent()) {
            return;
        }
        NPCTrainer trainer = entityNPCOptional.get();
        TrainerPartyStorage storage = trainer.getPokemonStorage();
        if (storage.hasSpace()) {
            storage.add(PokemonFactory.create(PixelmonSpecies.BULBASAUR.getValueUnsafe()));
        }
        trainer.updateTrainerLevel();
        trainer.getPokemonStorage().sendCacheToPlayer(player);
        this.reply(context, new ChangePokemonOpenGUIPacket(storage.getTeam().size() - 1));
    }
}

