/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.moveskills;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.NetworkDirection;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class UseMoveSkillPacket
extends AbstractPixelmonPacket {
    private int selectedPixelmon;
    private MoveSkill moveSkill;
    private int entityID;
    private int x;
    private int y;
    private int z;
    private int side;
    private MoveSkill.EnumTargetType targetType;

    public UseMoveSkillPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public UseMoveSkillPacket(int selectedPixelmon, MoveSkill moveSkill) {
        super(PacketDirection.PLAY_SERVER, true);
        this.selectedPixelmon = selectedPixelmon;
        this.moveSkill = moveSkill;
        this.targetType = MoveSkill.EnumTargetType.NOTHING;
    }

    public UseMoveSkillPacket(int selectedPixelmon, MoveSkill moveSkill, int entityId, MoveSkill.EnumTargetType targetType) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.selectedPixelmon = selectedPixelmon;
        this.moveSkill = moveSkill;
        this.entityID = entityId;
        this.targetType = targetType;
    }

    public UseMoveSkillPacket(int selectedPixelmon, MoveSkill moveSkill, BlockPos pos, Direction side) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.selectedPixelmon = selectedPixelmon;
        this.moveSkill = moveSkill;
        this.x = pos.m_123341_();
        this.y = pos.m_123342_();
        this.z = pos.m_123343_();
        this.side = side.m_122411_();
        this.targetType = MoveSkill.EnumTargetType.BLOCK;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.selectedPixelmon = buf.readByte();
        this.moveSkill = MoveSkill.getMoveSkillByID(buf.m_130277_());
        this.targetType = MoveSkill.EnumTargetType.values()[buf.readByte()];
        switch (this.targetType) {
            case MISC_ENTITY: 
            case PLAYER: 
            case POKEMON: {
                this.entityID = buf.readInt();
                break;
            }
            case BLOCK: {
                this.x = buf.readInt();
                this.y = buf.readInt();
                this.z = buf.readInt();
                this.side = buf.readInt();
                this.targetType = MoveSkill.EnumTargetType.BLOCK;
            }
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeByte(this.selectedPixelmon);
        buf.m_130070_(this.moveSkill.id);
        buf.writeByte(this.targetType.ordinal());
        switch (this.targetType) {
            case MISC_ENTITY: 
            case PLAYER: 
            case POKEMON: {
                buf.writeInt(this.entityID);
                break;
            }
            case BLOCK: {
                buf.writeInt(this.x);
                buf.writeInt(this.y);
                buf.writeInt(this.z);
                buf.writeInt(this.side);
            }
        }
    }

    @Override
    protected void handlePacket(CustomPayloadEvent.Context context) {
        Level world = context.getSender().f_19853_;
        if (!PixelmonConfigProxy.getExternalMoves().isAllowExternalMoves()) {
            return;
        }
        ServerPlayer player = context.getSender();
        PlayerPartyStorage storage = StorageProxy.getPartyNow(player);
        Pokemon pokemon = storage.get(this.selectedPixelmon);
        if (pokemon == null || !pokemon.getPixelmonEntity().isPresent()) {
            return;
        }
        PixelmonEntity pixelmon = pokemon.getPixelmonEntity().orElse(null);
        if (pixelmon == null) {
            return;
        }
        MoveSkill moveSkill = this.moveSkill;
        if (moveSkill == null || !MoveSkill.getMoveSkills(pixelmon.getPokemon()).contains(moveSkill)) {
            return;
        }
        if (pixelmon.getPokemon().isMoveSkillCoolingDown(moveSkill)) {
            return;
        }
        if (this.targetType == MoveSkill.EnumTargetType.BLOCK) {
            pixelmon.setBlockTarget(this.x, this.y, this.z, Direction.values()[this.side], moveSkill.id);
        } else if (this.targetType != MoveSkill.EnumTargetType.NOTHING) {
            Entity entity = world.m_6815_(this.entityID);
            if (entity instanceof LivingEntity) {
                pixelmon.setAttackTarget((LivingEntity)entity, moveSkill.id);
            }
        } else {
            moveSkill.onUsed(pixelmon, null, MoveSkill.EnumTargetType.NOTHING);
        }
    }
}

